/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.login.LoginContext;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileOpenController {
    @Autowired
    private LoginContext loginContext;
    @Autowired
    private FileDownloadService fileDownloadService;
    @Autowired
    private ShareCrudService shareCrudService;

    @GetMapping(value={"/buckets/{bucket}/shareFiles/files/{shareId}/toAnyOne"})
    public void sharePreview(@PathVariable(required=false) String bucket, @PathVariable String shareId, HttpServletRequest request, HttpServletResponse response) {
        SharedFile sharedFile = this.shareCrudService.getSharedFile(bucket, shareId);
        this.fileDownloadService.downloadFile(bucket, sharedFile.getFileId(), InlineAttachment.inline, request, response);
    }

    @GetMapping(value={"/buckets/{bucket}/shareFiles/files/{shareId}/toAnyOne/download"})
    public void shareDownload(@PathVariable(required=false) String bucket, @PathVariable String shareId, HttpServletRequest request, HttpServletResponse response) {
        SharedFile sharedFile = this.shareCrudService.getSharedFile(bucket = TenantUtil.getBucketName((String)bucket), shareId);
        if (!sharedFile.isPubic()) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_ACCESS_DENY, new Object[]{UserUtils.getUserId(), sharedFile.getFileId()});
        }
        this.fileDownloadService.downloadFile(bucket, sharedFile.getFileId(), InlineAttachment.attachment, request, response);
    }

    @GetMapping(value={"/buckets/{bucket}/playvideo/{fileInfoId}"})
    public void filePreview(@PathVariable(required=false) String bucket, @PathVariable String fileInfoId, @RequestParam(name="usertoken") String userToken, HttpServletRequest request, HttpServletResponse response) {
        this.loginContext.analysis(userToken, request);
        this.fileDownloadService.downloadFile(bucket, fileInfoId, InlineAttachment.inline, request, response);
    }
}

