/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileRecycleController {
    @Autowired
    private FileRecycleService fileRecycleService;

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/recyclebins/{recycleId}/recover", "/myresources/recyclebins/{recycleId}/recover"})
    public ResponseEntity<?> recoverRecycleBin(@PathVariable(required=false) String bucket, @PathVariable String recycleId) {
        this.fileRecycleService.restoreRecycleBin(bucket, IdUtil.uuid((String)recycleId));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize
    @DeleteMapping(value={"/buckets/{bucket}/recyclebins/{recycleId}", "/myresources/recyclebins/{recycleId}"})
    public ResponseEntity<?> deleteRecycleBin(@PathVariable(required=false) String bucket, @PathVariable String recycleId) {
        this.fileRecycleService.deleteRecycleBin(bucket, IdUtil.uuid((String)recycleId));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize
    @DeleteMapping(value={"/buckets/{bucket}/recyclebins", "/myresources/recyclebins"})
    public ResponseEntity<?> emptyRecycleBin(@PathVariable(required=false) String bucket) {
        this.fileRecycleService.clearRecycleBin(bucket);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

