/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.annotation.UploadMark;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.service.admin.BucketService;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileShareController {
    @Autowired
    private BucketService bucketService;
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private ShareCrudService shareCrudService;
    @Autowired
    private FileUploadService fileUploadService;

    @UploadMark
    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/shareUploudFile", "/myresources/shareUploudFile"})
    public ResponseEntity<?> shareUploadV1(@PathVariable(required=false) String bucket, @RequestHeader(value="digi-middleware-drive-arg") FileInfo body, HttpServletRequest request) throws IOException {
        this.bucketService.tenantCheck(bucket, body);
        FileInfo fileInfo = this.fileUploadService.uploadFromStream(bucket, body, (InputStream)request.getInputStream());
        SharedFile sharedFile = this.shareCrudService.shareFile(bucket, fileInfo.getId().toString());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("fileId", sharedFile.getFileId());
        result.put("url", sharedFile.getUrl());
        return ResponseEntity.ok(result);
    }

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/ShareFiles", "/myresources/ShareFiles"})
    public ResponseEntity<?> shareFiles(@PathVariable(required=false) String bucket, @RequestBody List<String> fileIds) {
        this.fidCheckService.canOperateFileId(bucket, fileIds);
        ArrayList<String> sharedUrls = new ArrayList<String>();
        for (String fileId : fileIds) {
            SharedFile sharedFile = this.shareCrudService.shareFile(bucket, fileId);
            sharedUrls.add(sharedFile.getUrl());
        }
        return ResponseEntity.ok(sharedUrls);
    }

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/ShareFiles/d/{expireDay}", "/myresources/ShareFiles/d/{expireDay}"})
    public ResponseEntity<?> shareFiles(@PathVariable(required=false) String bucket, @RequestBody List<String> fileIds, @PathVariable long expireDay) {
        this.fidCheckService.canOperateFileId(bucket, fileIds);
        ArrayList<String> sharedUrls = new ArrayList<String>();
        for (String fileId : fileIds) {
            SharedFile sharedFile = this.shareCrudService.shareFile(bucket, fileId, expireDay);
            sharedUrls.add(sharedFile.getUrl());
        }
        return ResponseEntity.ok(sharedUrls);
    }
}

