/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v1.file;

import com.digiwin.dap.middleware.dmc.domain.UploadStatus;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.annotation.UploadMark;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.ContentModerator;
import com.digiwin.dap.middleware.dmc.service.admin.BucketService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.service.business.impl.FileUploadServiceDecryptedDecorator;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileUploadController {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadController.class);
    @Autowired
    private BucketService bucketService;
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private BucketRepository bucketRepository;

    @UploadMark
    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=11)
    @PostMapping(value={"/buckets/{bucket}/files", "/myresources/files"})
    public Callable<ResponseEntity<?>> uploadStream(@PathVariable(required=false, value="bucket") String bucket, @RequestHeader(value="digi-middleware-drive-arg") FileInfo body, @RequestHeader(value="digi-middleware-need-moderator", defaultValue="0") Boolean needModerator, HttpServletRequest request, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) throws IOException {
        this.bucketService.tenantCheck(bucket, body);
        ServletInputStream inputStream = request.getInputStream();
        return () -> {
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            FileInfo fileInfo = fileUploadServiceDecryptedDecorator.uploadFromStream(bucket, body, (InputStream)inputStream);
            ContentModerator.processSync((String)bucket, (FileInfo)fileInfo, (boolean)needModerator);
            return ResponseEntity.ok(Collections.singletonMap("id", fileInfo.getId()));
        };
    }

    @UploadMark
    @RoleAuthorize(action=ActionEnum.Write, type=FileTypeEnum.Directory, order=12)
    @PostMapping(value={"/buckets/{bucket}/files/{type}", "/myresources/files/{type}"})
    public ResponseEntity<?> uploadSegV1(@PathVariable(required=false) String bucket, @PathVariable(required=false) String type, @RequestBody FileInfo fileInfo) {
        this.bucketService.tenantCheck(bucket, fileInfo);
        String fileInfoId = this.fileUploadService.createEmptyFile(bucket, fileInfo);
        return ResponseEntity.ok(Collections.singletonMap("id", fileInfoId));
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1)
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/{from}/{to}/{total}/{partNum}", "/buckets/{bucket}/files/{fileId}/{from}/{to}/{total}", "/myresources/files/{fileId}/{from}/{to}/{total}"})
    public Callable<ResponseEntity<?>> upload(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="from") long from, @PathVariable(value="to") long to, @PathVariable(value="total") long total, @PathVariable(required=false, value="partNum") Integer partNum, HttpServletRequest request, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) throws IOException {
        byte[] bytes = IOUtils.inputStreamToByteArray((InputStream)request.getInputStream());
        return () -> {
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            fileUploadServiceDecryptedDecorator.uploadFromStream(bucket, fileId, bytes, from, to, total, partNum);
            return ResponseEntity.ok(Collections.singletonMap("id", fileId));
        };
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/buckets/{bucket}/files/{fileId}/status", "/myresources/files/{fileId}/status"})
    public ResponseEntity<?> getPartUploadStatus(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId) {
        UploadStatus uploadStatus = this.fileUploadService.getFileUploadStatus(bucket, fileId);
        return ResponseEntity.ok((Object)uploadStatus);
    }

    @UploadMark
    @RoleAuthorize(action=ActionEnum.Write, order=1)
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/cover", "/myresources/files/{fileId}/cover"})
    public Callable<ResponseEntity<?>> coverUploadV1(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileInfoId, HttpServletRequest request, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) throws IOException {
        return () -> {
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            fileUploadServiceDecryptedDecorator.coverUploadFromStream(bucket, fileInfoId, (InputStream)request.getInputStream());
            return ResponseEntity.ok(Collections.singletonMap("id", fileInfoId));
        };
    }

    @UploadMark
    @RoleAuthorize(action=ActionEnum.Write, order=1)
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/{from}/{to}/{total}/{partNum}/{partCount}/cover", "/buckets/{bucket}/files/{fileId}/{from}/{to}/{total}/cover", "/myresources/files/{fileId}/{from}/{to}/{total}/cover"})
    public Callable<ResponseEntity<?>> coverUploadSegV1(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="from") long from, @PathVariable(value="to") long to, @PathVariable(value="total") long total, @PathVariable(required=false, value="partNum") Integer partNum, HttpServletRequest request, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) throws IOException {
        if (from == 0L) {
            this.fileUploadService.coverEmptyFile(bucket, fileId);
        }
        byte[] bytes = IOUtils.inputStreamToByteArray((InputStream)request.getInputStream());
        return () -> {
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            fileUploadServiceDecryptedDecorator.uploadFromStream(bucket, fileId, bytes, from, to, total, partNum);
            return ResponseEntity.ok(Collections.singletonMap("id", fileId));
        };
    }
}

