/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2;

import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.domain.MoveSort;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import com.mongodb.client.model.Sorts;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/directory"})
public class DirectoryApi {
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private DirectoryCrudService directoryCrudService;
    @Autowired
    private DirectoryNodeService directoryNodeService;

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/rename"})
    public StdData<?> rename(@PathVariable String bucket, @RequestBody DirInfo body) {
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, body.getId());
        if (dirInfo != null) {
            this.fidCheckService.modDirCheck(bucket, dirInfo, dirInfo.getParentId(), body.getName());
            dirInfo.setName(body.getName());
            this.directoryCrudService.update((UuIdEntity)dirInfo);
        }
        return StdData.ok((Object)dirInfo);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}"})
    public StdData<?> create(@PathVariable String bucket, @RequestBody DirInfo body) {
        this.fidCheckService.newDirCheck(bucket, body);
        body.setBucket(bucket);
        String id = this.directoryCrudService.insert((UuIdEntity)body);
        return StdData.ok((Object)this.directoryNodeService.findById(body.getBucket(), id));
    }

    @RoleAuthorize
    @DeleteMapping(value={"/{bucket}/{id}"})
    public StdData<?> delete(@PathVariable String bucket, @PathVariable String id) {
        UUID dirId = IdUtil.uuid((String)id);
        this.directoryCrudService.deleteById(bucket, dirId);
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PutMapping(value={"/{bucket}"})
    public StdData<?> modify(@PathVariable String bucket, @RequestBody DirInfo body) {
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, body.getId());
        if (dirInfo != null) {
            body.setParentId(IdUtil.getDirId((UUID)body.getParentId()));
            this.fidCheckService.modDirCheck(bucket, dirInfo, body.getParentId(), body.getName());
            dirInfo.setName(body.getName());
            dirInfo.setDisplayName(body.getDisplayName());
            dirInfo.setParentId(body.getParentId());
            dirInfo.setDeletion(body.getDeletion());
            this.directoryCrudService.update((UuIdEntity)dirInfo);
            return StdData.ok((Object)dirInfo);
        }
        return StdData.ok().build();
    }

    @RoleAuthorize(admin=true, dirIndexes={1})
    @GetMapping(value={"/{bucket}/{id}"})
    public StdData<?> findById(@PathVariable String bucket, @PathVariable String id) {
        UUID dirId = IdUtil.uuid((String)id);
        return StdData.ok((Object)this.directoryNodeService.findById(bucket, dirId));
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/{bucket}"})
    public StdData<?> find(@PathVariable String bucket) {
        return StdData.ok((Object)this.directoryNodeService.findAll(bucket));
    }

    @RoleAuthorize(admin=true)
    @PostMapping(value={"/{bucket}/search"})
    public StdData<?> search(@PathVariable String bucket, @RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.directoryCrudService.findByPage(bucket, body));
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/{bucket}/parent/{dirId}"})
    public StdData<?> findByParentId(@PathVariable String bucket, @PathVariable String dirId, @RequestParam(defaultValue="0") int sort, @RequestParam(defaultValue="asc") String type) {
        UUID parentId = IdUtil.getDirId((String)dirId);
        List dirInfos = this.directoryNodeService.findByParentId(bucket, parentId, BsonUtil.sort((int)sort, (String)type, (FileTypeEnum)FileTypeEnum.Directory));
        return StdData.ok((Object)dirInfos);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/info"})
    public StdData<?> findByName(@PathVariable String bucket, @RequestBody DirInfo body) {
        UUID parentId = IdUtil.getDirId((UUID)body.getParentId());
        DirInfo dirInfo = this.directoryNodeService.findByNamePath(bucket, parentId, body.getName());
        return StdData.ok((Object)dirInfo);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/move"})
    public StdData<?> move(@PathVariable String bucket, @RequestBody MoveSort body) {
        UUID parentId;
        DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, body.getId());
        UUID uUID = parentId = body.getParentId() == null ? null : IdUtil.getDirId((String)body.getParentId());
        if (dirInfo == null || Objects.equals(dirInfo.getId(), parentId)) {
            return StdData.ok().build();
        }
        if (parentId != null) {
            dirInfo.setParentId(parentId);
        }
        dirInfo.setSort(body.getIndex());
        this.directoryNodeService.replace((UuIdEntity)dirInfo);
        List dirInfos = this.directoryNodeService.findByParentId(bucket, dirInfo.getParentId(), Sorts.ascending((String[])new String[]{"sort"}));
        Map sortMap = BsonUtil.sort((UUID)dirInfo.getId(), (int)body.getIndex(), (List)dirInfos);
        sortMap.forEach((key, value) -> this.directoryNodeService.sort(bucket, key, value.intValue()));
        return StdData.ok().build();
    }
}

