/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2;

import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.MoveSort;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.util.BeanUtil;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.conversions.Bson;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/fileinfo"})
public class FileInfoApi {
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/rename"})
    public StdData<?> rename(@PathVariable String bucket, @RequestBody FileInfo body) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, body.getId());
        if (fileInfo != null) {
            fileInfo.setFileName(FileUtil.getBaseName((String)body.getFileName()) + "." + fileInfo.getExtension());
            fileInfo.setFullText(FileUtil.getFullText((FileInfo)fileInfo));
            this.fileInfoCrudService.update((UuIdEntity)fileInfo);
        }
        return StdData.ok((Object)fileInfo);
    }

    @RoleAuthorize
    @PutMapping(value={"/{bucket}"})
    public StdData<?> modify(@PathVariable String bucket, @RequestBody FileInfo body) {
        FileInfo fileInfo = (FileInfo)this.fileInfoCrudService.findById(bucket, body.getId());
        if (fileInfo != null) {
            this.fidCheckService.fillDirName(bucket, fileInfo);
            BeanUtils.copyProperties((Object)body, (Object)fileInfo, (String[])BeanUtil.getNullOrZero((Object)body));
            this.fileInfoCrudService.update((UuIdEntity)fileInfo);
            return StdData.ok((Object)fileInfo);
        }
        return StdData.ok().build();
    }

    @RoleAuthorize(admin=true, fileIndexes={1})
    @GetMapping(value={"/{bucket}/{id}"})
    public StdData<?> findById(@PathVariable String bucket, @PathVariable String id) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, id);
        this.fidCheckService.fillDirName(bucket, fileInfo);
        return StdData.ok((Object)fileInfo);
    }

    @RoleAuthorize(admin=true)
    @PostMapping(value={"/{bucket}/search"})
    public StdData<?> search(@PathVariable String bucket, @RequestBody(required=false) Page body) {
        PageData pageData = this.fileInfoCrudService.findByPage(bucket, body);
        this.fidCheckService.fillDirName(bucket, pageData.getList());
        return StdData.ok((Object)pageData);
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/{bucket}/directory/{dirId}"})
    public StdData<?> findByDirectoryId(@PathVariable String bucket, @PathVariable String dirId, @RequestParam(defaultValue="0") int sort, @RequestParam(defaultValue="asc") String type) {
        String directoryId = IdUtil.getDirectoryId((String)dirId);
        List fileInfos = this.fileNodeService.findByDirId(bucket, directoryId, BsonUtil.sort((int)sort, (String)type, (FileTypeEnum)FileTypeEnum.File));
        this.fidCheckService.fillDirName(bucket, fileInfos);
        return StdData.ok((Object)fileInfos);
    }

    @RoleAuthorize(admin=true)
    @PostMapping(value={"/{bucket}/ids"})
    public StdData<?> findByIds(@PathVariable String bucket, @RequestBody List<String> fileIds) {
        Bson filter = Filters.in((String)"_id", (Iterable)IdUtil.validUuid(fileIds));
        List fileInfos = this.fileNodeService.findByCondition(bucket, filter);
        this.fidCheckService.fillDirName(bucket, fileInfos);
        return StdData.ok((Object)fileInfos);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/info"})
    public StdData<?> findByName(@PathVariable String bucket, @RequestBody FileInfo body) {
        String dirId = IdUtil.getDirectoryId((String)body.getDirectoryId());
        FileInfo fileInfo = this.fileNodeService.findByFileName(bucket, dirId, body.getFileName());
        this.fidCheckService.fillDirName(bucket, fileInfo);
        return StdData.ok((Object)fileInfo);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/move"})
    public StdData<?> move(@PathVariable String bucket, @RequestBody MoveSort body) {
        String dirId;
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, body.getId());
        if (fileInfo == null) {
            return StdData.ok().build();
        }
        String string = dirId = body.getParentId() == null ? null : IdUtil.getDirectoryId((String)body.getParentId());
        if (dirId != null) {
            fileInfo.setDirectoryId(dirId);
        }
        fileInfo.setSort(body.getIndex());
        this.fileNodeService.replace((UuIdEntity)fileInfo);
        List fileInfos = this.fileNodeService.findByDirId(bucket, fileInfo.getDirectoryId(), Sorts.ascending((String[])new String[]{"sort"}));
        Map sortMap = BsonUtil.sort((UUID)fileInfo.getId(), (int)body.getIndex(), (List)fileInfos);
        sortMap.forEach((key, value) -> this.fileNodeService.sort(bucket, key, value.intValue()));
        return StdData.ok().build();
    }
}

