/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/share"})
public class ShareApi {
    @Autowired
    private ShareCrudService shareCrudService;

    @RoleAuthorize
    @DeleteMapping(value={"/{bucket}/{id}"})
    public StdData<?> delete(@PathVariable String bucket, @PathVariable UUID id) {
        this.shareCrudService.deleteById(bucket, id);
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PutMapping(value={"/{bucket}"})
    public StdData<?> modify(@PathVariable String bucket, @RequestBody SharedFile body) {
        body.setBucket(bucket);
        this.shareCrudService.update((UuIdEntity)body);
        return StdData.ok((Object)this.shareCrudService.findById(body.getBucket(), body.getId()));
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/{bucket}/{id}"})
    public StdData<?> findById(@PathVariable String bucket, @PathVariable String id) {
        return StdData.ok((Object)this.shareCrudService.findById(bucket, id));
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/{bucket}"})
    public StdData<?> find(@PathVariable String bucket) {
        return StdData.ok((Object)this.shareCrudService.findAll(bucket));
    }

    @RoleAuthorize(admin=true)
    @PostMapping(value={"/{bucket}/search"})
    public StdData<?> search(@PathVariable String bucket, @RequestBody(required=false) Page body) {
        return StdData.ok((Object)this.shareCrudService.findByPage(bucket, body));
    }
}

