/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.dao.BackupCrudService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.uuid.Backup;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileBackupApi {
    @Autowired
    private BackupCrudService backupCrudService;
    @Autowired
    private FileDownloadService fileDownloadService;

    @RoleAuthorize(admin=true)
    @PostMapping(value={"/{bucket}/backup/search"})
    public StdData<?> search(@PathVariable String bucket, @RequestBody(required=false) Page body) {
        PageData pageData = this.backupCrudService.findByPage(bucket, body);
        return StdData.ok((Object)pageData);
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/{bucket}/backup/files/{fileId}"})
    public StdData<?> findByFileId(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        List backups = this.backupCrudService.findByFileId(bucket, IdUtil.uuid((String)fileId), 0, 0);
        return StdData.ok((Object)backups);
    }

    @RoleAuthorize
    @DeleteMapping(value={"/{bucket}/backup/delete/{backId}"})
    public StdData<?> delete(@PathVariable(required=false) String bucket, @PathVariable String backId) {
        this.backupCrudService.delBackup(bucket, IdUtil.uuid((String)backId));
        return StdData.ok().build();
    }

    @GetMapping(value={"/{bucket}/backup/download/{backId}"})
    public void download(@PathVariable(required=false) String bucket, @PathVariable String backId, HttpServletRequest request, HttpServletResponse response) {
        Backup backup = (Backup)this.backupCrudService.findById(bucket, backId);
        this.fileDownloadService.downloadFile(bucket, (FileInfo)backup, InlineAttachment.attachment, request, response);
    }
}

