/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.service.business.FileService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileCopyApi {
    @Autowired
    private FileService fileService;

    @RoleAuthorize(fileIndexes={1}, dirIndexes={2})
    @PostMapping(value={"/{bucket}/copy/{fileId}/{targetDirId}"})
    public StdData<?> copyFile(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String targetDirId) {
        String copyId = this.fileService.copyFile(bucket, IdUtil.uuid((String)fileId), IdUtil.getDirId((String)targetDirId));
        return StdData.ok(Collections.singletonMap("fileId", copyId));
    }

    @RoleAuthorize(dirIndexes={1, 2})
    @PostMapping(value={"/{bucket}/copy/dir/{dirId}/{targetDirId}"})
    public StdData<?> copyDir(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String targetDirId) {
        String copyId = this.fileService.copyDir(bucket, IdUtil.getDirId((String)dirId), IdUtil.getDirId((String)targetDirId));
        return StdData.ok(Collections.singletonMap("dirId", copyId));
    }

    @RoleAuthorize(dirIndexes={2})
    @PostMapping(value={"/{bucket}/copy/{targetDirId}"})
    public StdData<?> copyFiles(@PathVariable(required=false) String bucket, @RequestBody BatchFid body, @PathVariable String targetDirId) {
        body.afterPropertiesSet();
        return StdData.ok((Object)this.fileService.batchCopy(bucket, body, IdUtil.getDirId((String)targetDirId)));
    }
}

