/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.entity.uuid.RecycleBin;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileDeleteApi {
    @Autowired
    private FileRecycleService fileRecycleService;

    @RoleAuthorize(fileIndexes={1})
    @DeleteMapping(value={"/{bucket}/delete/force/{fileId}"})
    public StdData<?> deleteForce(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/delete/force"})
    public StdData<?> deleteForce(@PathVariable(required=false) String bucket, @RequestBody BatchFid body) {
        body.afterPropertiesSet();
        for (String fileId : body.getFileIds()) {
            this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
        }
        for (String dirId : body.getDirIds()) {
            this.fileRecycleService.removeDir(bucket, IdUtil.getDirId((String)dirId));
        }
        return StdData.ok().build();
    }

    @RoleAuthorize(fileIndexes={1})
    @DeleteMapping(value={"/{bucket}/delete/{fileId}"})
    public StdData<?> delete(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        RecycleBin recyclebin = this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
        return StdData.ok((Object)recyclebin);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/delete"})
    public StdData<?> delete(@PathVariable(required=false) String bucket, @RequestBody BatchFid body) {
        RecycleBin recycleBin;
        body.afterPropertiesSet();
        ArrayList<RecycleBin> recycleBins = new ArrayList<RecycleBin>();
        for (String fileId : body.getFileIds()) {
            recycleBin = this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)fileId));
            if (recycleBin == null) continue;
            recycleBins.add(recycleBin);
        }
        for (String dirId : body.getDirIds()) {
            recycleBin = this.fileRecycleService.removeDir(bucket, IdUtil.getDirId((String)dirId));
            if (recycleBin == null) continue;
            recycleBins.add(recycleBin);
        }
        return StdData.ok(recycleBins);
    }
}

