/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.domain.v2.FileTree;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileHandlerService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileDownloadApi {
    @Autowired
    private FileHandlerService fileHandlerService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileDownloadService fileDownloadService;

    @RoleAuthorize(fileIndexes={1})
    @GetMapping(value={"/{bucket}/download/{fileId}"})
    public void download(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        this.fileDownloadService.downloadFile(bucket, fileId, InlineAttachment.attachment, request, response);
    }

    @RoleAuthorize(dirIndexes={1})
    @GetMapping(value={"/{bucket}/download/dir/{dirId}"})
    public void downloadDir(@PathVariable(required=false) String bucket, @PathVariable String dirId, HttpServletRequest request, HttpServletResponse response) {
        FileTree dirTree = this.fileNodeService.findFileTree(bucket, IdUtil.getDirectoryId((String)dirId), null);
        List<FileTree> fileTrees = Collections.singletonList(dirTree);
        String fileName = this.fileHandlerService.getFileName(fileTrees);
        this.fileHandlerService.compressFile(bucket, fileTrees, fileName, request, response);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/download/multi"})
    public void downloadMulti(@PathVariable(required=false) String bucket, @RequestBody BatchFid body, HttpServletRequest request, HttpServletResponse response) {
        List fileTrees = this.fileHandlerService.getFileTrees(bucket, body);
        String fileName = this.fileHandlerService.getFileName(fileTrees);
        this.fileHandlerService.compressFile(bucket, fileTrees, fileName, request, response);
    }
}

