/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.service.business.FileService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileMoveApi {
    @Autowired
    private FileService fileService;

    @RoleAuthorize(fileIndexes={1}, dirIndexes={2})
    @PostMapping(value={"/{bucket}/move/{fileId}/{targetDirId}"})
    public StdData<?> moveFile(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String targetDirId) {
        this.fileService.moveFile(bucket, IdUtil.uuid((String)fileId), IdUtil.getDirId((String)targetDirId));
        return StdData.ok().build();
    }

    @RoleAuthorize(dirIndexes={1, 2})
    @PostMapping(value={"/{bucket}/move/dir/{dirId}/{targetDirId}"})
    public StdData<?> moveDir(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String targetDirId) {
        this.fileService.moveDir(bucket, IdUtil.getDirId((String)dirId), IdUtil.getDirId((String)targetDirId));
        return StdData.ok().build();
    }

    @RoleAuthorize(dirIndexes={2})
    @PostMapping(value={"/{bucket}/move/{targetDirId}"})
    public StdData<?> moveManyFileInfo(@PathVariable(required=false) String bucket, @RequestBody BatchFid body, @PathVariable String targetDirId) {
        body.afterPropertiesSet();
        for (String fileId : body.getFileIds()) {
            this.fileService.moveFile(bucket, IdUtil.uuid((String)fileId), IdUtil.getDirId((String)targetDirId));
        }
        for (String dirId : body.getDirIds()) {
            this.fileService.moveDir(bucket, IdUtil.getDirId((String)dirId), IdUtil.getDirId((String)targetDirId));
        }
        return StdData.ok().build();
    }
}

