/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.domain.enumeration.ShareType;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileHandlerService;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileOpenApi {
    @Autowired
    private FileDownloadService fileDownloadService;
    @Autowired
    private ShareCrudService shareCrudService;
    @Autowired
    private FileHandlerService fileHandlerService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileRecycleService fileRecycleService;

    @Deprecated
    @GetMapping(value={"/{bucket}/share/{shareId}"}, consumes={"application/json"})
    public StdData<?> shareInfo(@PathVariable String bucket, @PathVariable String shareId) {
        SharedFile sharedFile = this.shareCrudService.getSharedFile(bucket, shareId);
        List fileTrees = this.fileHandlerService.getFileTrees(bucket, new BatchFid(sharedFile));
        return StdData.ok((Object)fileTrees);
    }

    @GetMapping(value={"/{bucket}/share/{shareId}"})
    public void sharePreview(@PathVariable String bucket, @PathVariable String shareId, HttpServletRequest request, HttpServletResponse response) {
        SharedFile sharedFile = this.shareCrudService.getSharedFile(bucket, shareId);
        if (sharedFile.getType() == ShareType.One) {
            this.fileDownloadService.downloadFile(bucket, sharedFile.getFileId(), InlineAttachment.inline, request, response);
        } else {
            List fileTrees = this.fileHandlerService.getFileTrees(bucket, new BatchFid(sharedFile));
            String fileName = this.fileHandlerService.getFileName(fileTrees);
            this.fileHandlerService.compressFile(bucket, fileTrees, fileName, request, response);
        }
        if (sharedFile.getAllowCount() != null) {
            this.shareCrudService.allowCount(bucket, sharedFile.getId());
            SharedFile shared = (SharedFile)this.shareCrudService.findById(bucket, sharedFile.getId());
            if (shared.getAllowCount() <= 0 && shared.getDeleteFile() != null && shared.getDeleteFile().booleanValue()) {
                this.fileRecycleService.removeFile(bucket, IdUtil.uuid((String)sharedFile.getFileId()));
            }
        }
    }

    @GetMapping(value={"/{bucket}/share/{shareId}/download"})
    public void shareDownload(@PathVariable String bucket, @PathVariable String shareId, HttpServletRequest request, HttpServletResponse response) {
        SharedFile sharedFile = this.shareCrudService.getSharedFile(bucket, shareId);
        if (sharedFile.getType() == ShareType.One) {
            this.fileDownloadService.downloadFile(bucket, sharedFile.getFileId(), InlineAttachment.attachment, request, response);
        } else {
            List fileTrees = this.fileHandlerService.getFileTrees(bucket, new BatchFid(sharedFile));
            String fileName = this.fileHandlerService.getFileName(fileTrees);
            this.fileHandlerService.compressFile(bucket, fileTrees, fileName, request, response);
        }
    }

    @Deprecated
    @GetMapping(value={"/{bucket}/download/2/{fileId}"})
    public ResponseEntity<Resource> download(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileId);
        byte[] bytes = this.fileDownloadService.downloadToBytes(bucket, fileId, request, response);
        ByteArrayResource file = new ByteArrayResource(bytes);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + fileInfo.getFileName()})).body((Object)file);
    }

    @GetMapping(value={"/{bucket}/preview/{fileId}"})
    public void preview(@PathVariable(required=false) String bucket, @PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        this.fileDownloadService.downloadFile(bucket, fileId, InlineAttachment.inline, request, response);
    }

    @GetMapping(value={"/{bucket}/preview/name/{fileName:.+}"})
    public void previewByName(@PathVariable(required=false) String bucket, @PathVariable String fileName, HttpServletRequest request, HttpServletResponse response) {
        try {
            String id = fileName.split("\\.")[0];
            String fileId = IdUtil.uuid((String)id).toString();
            this.fileDownloadService.downloadFile(bucket, fileId, InlineAttachment.inline, request, response);
        }
        catch (Exception e) {
            this.fileDownloadService.downloadFile(bucket, null, fileName, InlineAttachment.inline, request, response);
        }
    }

    @GetMapping(value={"/{bucket}/preview/{dirId}/{fileName:.+}"})
    public void previewByName(@PathVariable(required=false) String bucket, @PathVariable String dirId, @PathVariable String fileName, HttpServletRequest request, HttpServletResponse response) {
        this.fileDownloadService.downloadFile(bucket, dirId, fileName, InlineAttachment.inline, request, response);
    }
}

