/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.service.business.FileRecycleService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileRecycleApi {
    @Autowired
    private FileRecycleService fileRecycleService;

    @RoleAuthorize
    @DeleteMapping(value={"/{bucket}/recycle/delete/{recycleId}"})
    public StdData<?> recycleDelete(@PathVariable String bucket, @PathVariable String recycleId) {
        this.fileRecycleService.deleteRecycleBin(bucket, IdUtil.uuid((String)recycleId));
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/recycle/delete"})
    public StdData<?> recycleDelete(@PathVariable String bucket, @RequestBody BatchFid body) {
        for (String recycleId : body.getRecycleIds()) {
            this.fileRecycleService.deleteRecycleBin(bucket, IdUtil.uuid((String)recycleId));
        }
        return StdData.ok().build();
    }

    @RoleAuthorize
    @DeleteMapping(value={"/{bucket}/recycle/clear"})
    public StdData<?> recycleClear(@PathVariable String bucket) {
        this.fileRecycleService.clearRecycleBin(bucket);
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/recycle/restore/{recycleId}"})
    public StdData<?> recycleRestore(@PathVariable String bucket, @PathVariable String recycleId) {
        this.fileRecycleService.restoreRecycleBin(bucket, IdUtil.uuid((String)recycleId));
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/recycle/restore"})
    public StdData<?> recycleRestore(@PathVariable String bucket, @RequestBody BatchFid body) {
        for (String recycleId : body.getRecycleIds()) {
            this.fileRecycleService.restoreRecycleBin(bucket, IdUtil.uuid((String)recycleId));
        }
        return StdData.ok().build();
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/recycle/restore/file"})
    public StdData<?> recycleRestoreFile(@PathVariable String bucket, @RequestBody BatchFid body) {
        for (String fileId : body.getFileIds()) {
            this.fileRecycleService.restoreFile(bucket, IdUtil.uuid((String)fileId));
        }
        return StdData.ok().build();
    }
}

