/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileShareApi {
    @Autowired
    private ShareCrudService shareCrudService;

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/share"})
    public StdData<?> share(@PathVariable String bucket, @RequestBody BatchFid body) {
        body.afterPropertiesSet();
        SharedFile sharedFile = this.shareCrudService.shareFile(bucket, body);
        return StdData.ok((Object)sharedFile);
    }

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/share/delete"})
    public StdData<?> shareDelete(@PathVariable String bucket, @RequestBody BatchFid body) {
        Set uuids = body.getShareIds().stream().map(UUID::fromString).collect(Collectors.toSet());
        return StdData.ok((Object)this.shareCrudService.deleteByIdIn(bucket, uuids));
    }
}

