/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.file.v2.file;

import com.digiwin.dap.middleware.dmc.constant.I18nCode;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.annotation.UploadMark;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.ContentModerator;
import com.digiwin.dap.middleware.dmc.service.admin.BucketService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.service.business.impl.FileUploadServiceDecryptedDecorator;
import com.digiwin.dap.middleware.domain.StdData;
import com.mongodb.client.model.Filters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.IntStream;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/dmc/v2/file"})
public class FileUploadApi {
    @Autowired
    private BucketService bucketService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private BucketRepository bucketRepository;

    @RoleAuthorize
    @PostMapping(value={"/{bucket}/rapid/upload"})
    public StdData<?> rapidUpload(@PathVariable String bucket, @RequestBody FileInfo body) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"hash", (Object)body.getHash()), Filters.eq((String)"size", (Object)body.getSize())});
        List fileInfos = this.fileNodeService.findByCondition(bucket, filter);
        if (fileInfos.isEmpty()) {
            return StdData.of((int)404, (String)I18nCode.DMC_FILE_MD5_NONE.getMessage());
        }
        return StdData.ok(fileInfos.get(0));
    }

    @UploadMark
    @RoleAuthorize
    @PostMapping(value={"/{bucket}/upload"})
    public Callable<StdData<?>> uploadForm(@PathVariable(required=false) String bucket, @RequestPart(value="file") MultipartFile file, @RequestHeader(value="digi-middleware-need-moderator", defaultValue="0") Boolean needModerator, @RequestPart(required=false, name="fileInfo") FileInfo body, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) {
        this.bucketService.tenantCheck(bucket, body);
        return () -> {
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            FileInfo fileInfo = fileUploadServiceDecryptedDecorator.uploadFromFile(bucket, body == null ? new FileInfo() : body, file);
            ContentModerator.processSync((String)bucket, (FileInfo)fileInfo, (boolean)needModerator);
            return StdData.ok((Object)fileInfo);
        };
    }

    @UploadMark
    @RoleAuthorize
    @PostMapping(value={"/{bucket}/upload/cover"})
    public Callable<StdData<?>> coverUpload(@PathVariable(required=false) String bucket, @RequestPart(value="file") MultipartFile file, @RequestPart(value="fileId") String fileId, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) {
        return () -> {
            if (file.getSize() <= 0L) {
                return StdData.ok((Object)this.fileNodeService.findOne(bucket, fileId));
            }
            try (InputStream inputStream = file.getInputStream();){
                FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
                FileInfo fileInfo = fileUploadServiceDecryptedDecorator.coverUploadFromStream(bucket, fileId, inputStream);
                StdData stdData = StdData.ok((Object)fileInfo);
                return stdData;
            }
        };
    }

    @UploadMark
    @RoleAuthorize
    @PostMapping(value={"/{bucket}/upload/multi"})
    public Callable<StdData<?>> batchUpload(@PathVariable(required=false) String bucket, @RequestPart(value="files") MultipartFile[] files, @RequestPart(required=false, name="fileInfos") List<FileInfo> body, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) {
        this.bucketService.tenantCheck(bucket, body, (long)files.length);
        return () -> {
            List fileInfos = body == null ? new ArrayList() : body;
            int lackCount = files.length - fileInfos.size();
            if (lackCount > 0) {
                IntStream.range(0, lackCount).mapToObj(i -> new FileInfo()).forEach(fileInfos::add);
            }
            FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
            IntStream.range(0, files.length).forEach(i -> fileUploadServiceDecryptedDecorator.uploadFromFile(bucket, (FileInfo)fileInfos.get(i), files[i]));
            return StdData.ok((Object)fileInfos);
        };
    }
}

