/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.temp;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsMigration;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.UpdateResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class CoaAppController {
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private FileInfoStatService fileInfoStatService;
    @Autowired
    private DirectoryNodeService directoryNodeService;

    public static Map<UUID, String> buildFullPathMap(List<DirInfo> dirList) {
        Map idDirMap = dirList.stream().collect(Collectors.toMap(UuIdEntity::getId, Function.identity()));
        HashMap<UUID, String> pathMap = new HashMap<UUID, String>();
        for (DirInfo dir : dirList) {
            pathMap.put(dir.getId(), CoaAppController.buildPath((DirInfo)dir, idDirMap, pathMap));
        }
        return pathMap;
    }

    private static String buildPath(DirInfo dir, Map<UUID, DirInfo> idDirMap, Map<UUID, String> pathCache) {
        String path;
        if (dir == null) {
            return "";
        }
        if (pathCache.containsKey(dir.getId())) {
            return pathCache.get(dir.getId());
        }
        if (dir.getParentId() == BaseField.EMPTY_UUID || !idDirMap.containsKey(dir.getParentId())) {
            path = dir.getName();
        } else {
            DirInfo parent = idDirMap.get(dir.getParentId());
            path = CoaAppController.buildPath((DirInfo)parent, idDirMap, pathCache) + "/" + dir.getName();
        }
        pathCache.put(dir.getId(), path);
        return path;
    }

    @PostMapping(value={"/api/dmc/v1/coa/{bucket}/stats"})
    public ResponseEntity<?> stats(@PathVariable String bucket) {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        List results = this.fileInfoStatService.fileStatsByMigration(bucket);
        StatsMigration downloaded = results.stream().filter(p -> p.getMigration() == Boolean.TRUE).findFirst().orElse(null);
        StatsMigration remaining = results.stream().filter(p -> p.getMigration() == Boolean.FALSE).findFirst().orElse(null);
        stats.put("downloadedCount", downloaded == null ? 0L : downloaded.getCount());
        stats.put("downloadedSize", downloaded == null ? 0L : downloaded.getSize());
        stats.put("remainingCount", remaining == null ? 0L : remaining.getCount());
        stats.put("remainingSize", remaining == null ? 0L : remaining.getSize());
        stats.put("totalCount", (Long)stats.get("downloadedCount") + (Long)stats.get("remainingCount"));
        stats.put("totalSize", (Long)stats.get("downloadedSize") + (Long)stats.get("remainingSize"));
        return ResponseEntity.ok(stats);
    }

    @PostMapping(value={"/api/dmc/v1/coa/{bucket}/query"})
    public ResponseEntity<?> query(@PathVariable String bucket) {
        Bson filter = Filters.or((Bson[])new Bson[]{Filters.eq((String)"migration", null), Filters.eq((String)"migration", (Object)Boolean.FALSE)});
        Bson sort = Sorts.descending((String[])new String[]{"createDate"});
        Bson include = Projections.include((String[])new String[]{"_id", "fileName", "size", "directoryId"});
        List fileInfos = this.fileNodeService.findByCondition(bucket, filter, include, sort, 0, 100);
        List dirInfos = this.directoryNodeService.findAll(bucket);
        Map pathMap = CoaAppController.buildFullPathMap((List)dirInfos);
        fileInfos.forEach(fileInfo -> fileInfo.setDirectoryId((String)pathMap.get(IdUtil.getDirId((String)fileInfo.getDirectoryId()))));
        return ResponseEntity.ok((Object)fileInfos);
    }

    @PostMapping(value={"/api/dmc/v1/coa/{bucket}/mark"})
    public ResponseEntity<?> mark(@PathVariable String bucket, @RequestParam UUID fileId) {
        FileInfo fileInfo = (FileInfo)this.fileInfoCrudService.findById(bucket, fileId);
        fileInfo.setMigration(Boolean.TRUE);
        this.fileInfoCrudService.replace((UuIdEntity)fileInfo);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/api/dmc/v1/coa/{bucket}/reset"})
    public ResponseEntity<?> reset(@PathVariable String bucket) {
        UpdateResult updateResult = this.fileInfoCrudService.migrationSwitchReset(bucket);
        return ResponseEntity.ok((Object)updateResult);
    }
}

