/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.temp;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.dmc.constant.CloudTypeEnum;
import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.MigrationFile;
import com.digiwin.dap.middleware.dmc.domain.MigrationTenantFile;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.domain.migration.TenantFileSyncRequest;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.support.remote.DmcService;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MigrationController {
    private static final Logger logger = LoggerFactory.getLogger(MigrationController.class);
    private static final int PAGE_SIZE = 1000;
    private static final long FILE_SIZE_MB = 0x500000L;
    public static final long PAUSE_TIME_MILLIS = 1000L;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileStorageFactory fileStorageFactory;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private FileInfoStatService fileInfoStatService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private DirectoryNodeService directoryNodeService;
    @Autowired
    private DirectoryCrudService directoryCrudService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileUploadService fileUploadService;

    @PostMapping(value={"/api/dmc/v2/migration/tenant/file"})
    public ResponseEntity<?> migration(@RequestBody MigrationTenantFile body) {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (String bucket : body.getBuckets()) {
            Bson filter = Filters.eq((String)"tenantId", (Object)body.getTenantId());
            List fileInfos = this.fileNodeService.findByCondition(bucket, filter);
            for (FileInfo fileInfo : fileInfos) {
                fileInfo.setBucket(body.getNewBucket());
                fileInfo.setTenantId(body.getNewTenantId());
                this.fileNodeService.save((UuIdEntity)fileInfo);
                if (!body.getDelete().booleanValue()) continue;
                this.fileNodeService.deleteById(bucket, fileInfo.getId());
            }
            results.put(bucket, fileInfos.size());
        }
        return ResponseEntity.ok(results);
    }

    @PostMapping(value={"/api/dmc/v2/migration/file"})
    public ResponseEntity<?> migrationFile(@RequestBody MigrationFile body) {
        for (UUID fileId : body.getFileIds()) {
            FileInfo fileInfo = (FileInfo)this.fileInfoCrudService.findById(body.getBucket(), fileId);
            FileInfo first = this.fileInfoCrudService.findFirst(body.getBucket(), fileInfo.getId(), fileInfo.getFileId());
            if (first != null) {
                fileInfo.setFilePath(first.getFilePath());
                if (fileInfo.getDeletion() == null) {
                    fileInfo.setDeletion(Long.valueOf(0L));
                }
                fileInfo.setStorage(body.getStorage());
                fileInfo.setMigration(Boolean.TRUE);
                fileInfo.setBucket(body.getBucket());
                this.fileInfoCrudService.replace((UuIdEntity)fileInfo);
                continue;
            }
            this.migration(body.getBucket(), fileInfo, body.getStorage(), true);
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/api/dmc/v2/migration"})
    public ResponseEntity<?> migration(@RequestBody List<String> body) {
        int pageSize = 1000;
        for (String id : body) {
            List fileInfos;
            Bucket bucket = (Bucket)this.bucketRepository.findById(id);
            if (Objects.isNull(bucket)) continue;
            int pageNum = 0;
            long totalCount = 0L;
            logger.info("\u5b58\u50a8\u6876{}\u6570\u636e\u5f00\u59cb\u8fc1\u79fb", (Object)bucket.getName());
            while (!(fileInfos = this.fileInfoCrudService.findUnMigration(bucket.getName(), Integer.valueOf(pageNum), Integer.valueOf(pageSize))).isEmpty()) {
                for (FileInfo fileInfo : fileInfos) {
                    try {
                        this.migration(bucket.getName(), fileInfo, this.envProperties.getStorage(), false);
                        ++totalCount;
                    }
                    catch (Exception e) {
                        logger.error("[{}]: [{}]: {}", new Object[]{fileInfo.getBucket(), fileInfo.getId(), e.getMessage()});
                    }
                }
                logger.info("\u5b58\u50a8\u6876{}\u7b2c{}\u9875\u6570\u636e\u8fc1\u79fb\u5b8c\u6210", (Object)bucket.getName(), (Object)pageNum);
                ++pageNum;
            }
            this.updateUnMigration(bucket.getId());
            logger.info("\u5b58\u50a8\u6876{}\u6570\u636e\u8fc1\u79fb\u5b8c\u6210,\u8fc1\u79fb\u6587\u4ef6\u6570\u91cf:{}", (Object)bucket.getName(), (Object)totalCount);
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/api/dmc/v2/migration/switch"})
    public ResponseEntity<?> migrationSwitch(@RequestParam Boolean restore, @RequestBody List<String> body) {
        HashMap<String, UpdateResult> result = new HashMap<String, UpdateResult>();
        for (String id : body) {
            Bucket bucket = (Bucket)this.bucketRepository.findById(id);
            if (bucket == null) continue;
            UpdateResult updateResult = restore != false ? this.fileInfoCrudService.migrationSwitchRestore(bucket.getName(), this.envProperties.getStorage()) : this.fileInfoCrudService.migrationSwitch(bucket.getName(), this.envProperties.getStorage());
            result.put(bucket.getName(), updateResult);
            this.updateMigrationUnSwitch(bucket.getId());
        }
        return ResponseEntity.ok(result);
    }

    @PostMapping(value={"/api/dmc/v2/migration/flush"})
    public ResponseEntity<?> flushUnMigration(@RequestBody List<ObjectId> body) {
        if (body.isEmpty()) {
            body.addAll(this.bucketRepository.findAll().stream().map(ObIdEntity::getId).collect(Collectors.toList()));
        }
        for (ObjectId id : body) {
            this.updateUnMigration(id);
            this.updateMigrationUnSwitch(id);
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/api/dmc/v2/migration/tenant/sync/file"})
    public StdData<?> syneTenantAllInfo(@RequestBody TenantFileSyncRequest req, @RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        logger.info("\u5f00\u59cb \u540c\u6b65\u4e91\u4e0a\u79df\u6237\u6587\u4ef6\u8d44\u6599\u4e0b\u5730\uff0c\u6267\u884c\u4eba = {}\uff0c\u5165\u53c2\n {}", (Object)userInfo.getUserId(), (Object)req);
        if (CloudTypeEnum.CLOUD.getCode().equals(this.envProperties.getCloud())) {
            throw new BusinessException(String.format("\u5f53\u524d\u90e8\u7f72\u73af\u5883\u4e0d\u5141\u8bb8\u884c\u8fdb\u884c\u79df\u6237\u6587\u4ef6\u8d44\u6599\u540c\u6b65\u5230\u4e0b\u5730\u73af\u5883, cloud=%s, deployArea=%s, iamUri=%s", this.envProperties.getCloud(), this.envProperties.getDeployArea(), this.envProperties.getIamUri()));
        }
        Assert.hasLength((String)req.getSourceCloudArea(), (String)"\u6765\u6e90\u4e91\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)req.getUserToken(), (String)"\u6765\u6e90\u4e91\u533admc.userToken\u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.hasLength((String)req.getTenantId()) && CollectionUtils.isEmpty((Collection)req.getTenantIds())) {
            throw new BusinessException("\u79df\u6237ID\u548c\u79df\u6237ID\u96c6\u5408\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        Assert.notEmpty((Collection)req.getBuckets(), (String)"Bucket\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        DeployAreaEnum areaEnum = DeployAreaEnum.get((String)req.getSourceCloudArea());
        if (areaEnum == null) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6765\u6e90\u4e91\u533a\u4e0d\u5b58\u5728, SourceCloudArea={}", (Object[])new Object[]{req.getSourceCloudArea()}));
        }
        List<String> tenantIds = req.getTenantIds();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            tenantIds = Arrays.asList(req.getTenantId(), "99990000", "default", null, "");
        }
        logger.info("\u540c\u6b65\u4e91\u4e0a\u79df\u6237\u6587\u4ef6\u8d44\u6599\u4e0b\u5730, \u5b9e\u9645\u540c\u6b65\u7684 \u79df\u6237ID\u96c6\u5408 = {}", (Object)tenantIds);
        String userToken = req.getUserToken();
        String dmcUri = EnvUtils.getUri((CommonCode)CommonCode.DMC, (DeployAreaEnum)areaEnum);
        StringBuilder stringBuilder = new StringBuilder();
        List bucketList = this.bucketRepository.findAll();
        List bucketNameList = bucketList.stream().map(Bucket::getName).collect(Collectors.toList());
        for (String bucket : req.getBuckets()) {
            if (!bucketNameList.contains(bucket)) {
                logger.warn("\u5b58\u50a8\u6876{}\u4e0d\u5b58\u5728, \u8fdb\u884c\u8df3\u8fc7", (Object)bucket);
                stringBuilder.append(StrUtil.format((CharSequence)"\u5b58\u50a8\u6876{}\u4e0d\u5b58\u5728, \u8fdb\u884c\u8df3\u8fc7;", (Object[])new Object[]{bucket}));
                continue;
            }
            Page page = new Page();
            page.setPageSize(9999);
            PageData dirInfoPageData = this.dmcService.directorySearch(bucket, page, userToken, dmcUri);
            logger.info("\u8fdc\u7a0b\u5b58\u50a8\u6876{}\u6587\u4ef6\u5939\u6570\u91cf:{}", (Object)bucket, (Object)dirInfoPageData.getTotal());
            int bucketDirCount = 0;
            if (dirInfoPageData.getTotal() > 0L) {
                for (DirInfo dirInfo : dirInfoPageData.getList()) {
                    DirInfo existedInfo = (DirInfo)this.directoryNodeService.findById(bucket, dirInfo.getId());
                    if (existedInfo != null) continue;
                    if (!StringUtils.hasText((String)dirInfo.getBucket())) {
                        dirInfo.setBucket(bucket);
                    }
                    this.directoryCrudService.insert((UuIdEntity)dirInfo);
                    ++bucketDirCount;
                }
            }
            logger.info("bucket={}, \u8fc1\u79fb\u6587\u4ef6\u5939\u6570\u91cf:{}, fileTotal={} ", new Object[]{bucket, bucketDirCount, dirInfoPageData.getTotal()});
            this.sleepMillis();
            int saveCount = 0;
            Page fileSearchPage = new Page();
            fileSearchPage.setPageSize(1000);
            HashMap<String, List<String>> inFilters = new HashMap<String, List<String>>();
            inFilters.put("tenantId", tenantIds);
            fileSearchPage.setInFilters(inFilters);
            PageData fileInfoPageData = this.dmcService.fileSearch(bucket, fileSearchPage, userToken, dmcUri);
            long fileTotal = fileInfoPageData.getTotal();
            logger.info("bucket={}, \u5f00\u59cb\u8fc1\u79fb\u6587\u4ef6, fileTotal={}", (Object)bucket, (Object)fileTotal);
            if (fileTotal > 0L) {
                int dataSize;
                do {
                    dataSize = fileInfoPageData.getList().size();
                    logger.info("bucket={}, \u5f00\u59cb\u8fc1\u79fb\u6587\u4ef6, pageNum={}, pageSize={}, dataSize={}, fileTotal={}", new Object[]{bucket, fileSearchPage.getPageNum(), fileSearchPage.getPageSize(), dataSize, fileTotal});
                    int save = this.save(bucket, fileInfoPageData.getList(), userToken, dmcUri);
                    this.sleepMillis();
                    saveCount += save;
                    if (dataSize < 1000) continue;
                    fileSearchPage.setPageNum(fileSearchPage.getPageNum() + 1);
                    fileInfoPageData = this.dmcService.fileSearch(bucket, fileSearchPage, userToken, dmcUri);
                } while (dataSize >= 1000);
            }
            logger.info("bucket={}, \u5b8c\u6210\u8fc1\u79fb\u6587\u4ef6 fileTotal={}, saveCount={}", new Object[]{bucket, fileTotal, saveCount});
        }
        logger.info("\u5b8c\u6210 \u540c\u6b65\u4e91\u4e0a\u79df\u6237\u8d44\u6599\u4e0b\u5730");
        return StdData.ok((Object)stringBuilder.toString());
    }

    private int save(String bucket, List<FileInfo> remoteFileInfoList, String userToken, String dmcUri) {
        int save = 0;
        for (FileInfo remoteFileInfo : remoteFileInfoList) {
            FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, remoteFileInfo.getId());
            if (fileInfo != null) continue;
            byte[] bytes = this.dmcService.filePreview(bucket, remoteFileInfo.getId().toString(), userToken, dmcUri);
            if (bytes == null) {
                logger.error("bucket={}, fileId={} \u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Object)bucket, (Object)remoteFileInfo.getId());
                continue;
            }
            remoteFileInfo.setStorage(StorageEnum.MongoDB);
            this.fileUploadService.uploadFromBytes(bucket, remoteFileInfo, bytes);
            ++save;
            if (remoteFileInfo.getSize() < 0x500000L) continue;
            this.sleepMillis();
        }
        return save;
    }

    private void updateUnMigration(ObjectId id) {
        Bucket bucket = (Bucket)this.bucketRepository.findById(id);
        if (bucket != null) {
            long temp = this.fileInfoStatService.migrationCount(bucket.getName());
            bucket.setCount1(Long.valueOf(temp));
            this.bucketRepository.replace((ObIdEntity)bucket);
        }
    }

    private void updateMigrationUnSwitch(ObjectId id) {
        Bucket bucket = (Bucket)this.bucketRepository.findById(id);
        if (bucket != null) {
            long temp = this.fileInfoStatService.switchCount(bucket.getName());
            bucket.setCount2(Long.valueOf(temp));
            this.bucketRepository.replace((ObIdEntity)bucket);
        }
    }

    private void migration(String bucket, FileInfo fileInfo, StorageEnum targetStorage, boolean switchNow) {
        if (fileInfo.getStorage() == targetStorage) {
            return;
        }
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo);
        FileStorage targetFileStorage = this.fileStorageFactory.getFileStorage(bucket, fileInfo.getTenantId(), targetStorage);
        fileInfo.setBucket(bucket);
        byte[] bytes = fileStorage.downloadToBytes(fileInfo);
        targetFileStorage.uploadFromBytes(fileInfo, bytes);
        if (fileInfo.getDeletion() == null) {
            fileInfo.setDeletion(Long.valueOf(0L));
        }
        if (fileInfo.getStorage() == null) {
            fileInfo.setStorage(StorageEnum.MongoDB);
        }
        if (switchNow) {
            fileInfo.setStorage(targetStorage);
        }
        fileInfo.setMigration(Boolean.TRUE);
        this.fileInfoCrudService.replace((UuIdEntity)fileInfo);
    }

    private void sleepMillis() {
        try {
            logger.info("\u4f11\u606f{}s...", (Object)1L);
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

