/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.temp;

import com.digiwin.dap.middleware.dmc.domain.TenantFileInfoDTO;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsExtension;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsFile;
import com.digiwin.dap.middleware.dmc.domain.stats.StatsTenant;
import com.digiwin.dap.middleware.dmc.domain.v2.BucketStats;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.service.stats.StatsService;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StatsController {
    @Autowired
    private StatsService statsService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileInfoStatService fileInfoStatService;

    @PostMapping(value={"/api/dmc/v2/buckets/file/flush"})
    public void flushFile(@RequestBody List<ObjectId> body) {
        if (body.isEmpty()) {
            body.addAll(this.bucketRepository.findAll().stream().map(ObIdEntity::getId).collect(Collectors.toList()));
        }
        for (ObjectId id : body) {
            Bucket bucket = (Bucket)this.bucketRepository.findById(id);
            if (bucket != null) {
                BucketStats stats = this.fileInfoStatService.fileStatsByDeletion(bucket.getName());
                long size1 = stats.getTotalSize() / DataUtil.GB + 2L;
                long size2 = Math.round((double)stats.getTotalSize() * 1.2) / DataUtil.GB;
                bucket.setQuotaSize(Math.max(size1, size2) * DataUtil.GB);
                bucket.setTotalSize(stats.getTotalSize());
                bucket.setTotalCount(stats.getTotalCount());
                bucket.setFileSize(stats.getFileSize());
                bucket.setFileCount(stats.getFileCount());
                bucket.setDeleteSize(stats.getDeleteSize());
                bucket.setDeleteCount(stats.getDeleteCount());
            }
            this.bucketRepository.replace((ObIdEntity)bucket);
        }
    }

    @RoleAuthorize(admin=true)
    @GetMapping(value={"/api/dmc/v1/buckets/{bucket}/filesSize", "/api/dmc/v1/myresources/filesSize"})
    public ResponseEntity<?> getFilesSize(@PathVariable(required=false) String bucket) {
        StatsFile statsFile = this.fileInfoStatService.fileStats(bucket);
        return ResponseEntity.ok(Collections.singletonMap("fileLength", statsFile.getSize()));
    }

    @PostMapping(value={"/api/dmc/v2/stats/fileinfo/tenant"})
    public StdData<?> countUsedSpaceSizeByTenant(@RequestBody Bucket body) {
        ArrayList results = new ArrayList();
        if (StringUtils.hasText((String)body.getAppId())) {
            List buckets = this.bucketRepository.findByAppId(body.getAppId());
            List<String> bucketNames = buckets.stream().map(Bucket::getName).collect(Collectors.toList());
            bucketNames.forEach(bucketName -> {
                List statsTenants = this.fileInfoStatService.fileStatsByTenant(bucketName);
                ArrayList bucketSize = new ArrayList();
                for (StatsTenant statsTenant : statsTenants) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("tenantId", statsTenant.getTenantId());
                    map.put("count", statsTenant.getSize());
                    bucketSize.add(map);
                }
                results.add(Collections.singletonMap(bucketName, bucketSize));
            });
        }
        return StdData.ok(results);
    }

    @PostMapping(value={"/api/dmc/v2/fileinfo/tenant/update"})
    public StdData<?> updateFileInfoTenant(@RequestBody Map<String, List<TenantFileInfoDTO>> body, @RequestParam(defaultValue="false") Boolean force) {
        Map resultMap = this.statsService.updateFileInfoTenant(body, force);
        return StdData.ok((Object)resultMap);
    }

    @GetMapping(value={"/api/dmc/v2/stats/file/type"})
    public StdData<?> fileType(@RequestParam(defaultValue="false") Boolean detail) {
        List buckets = this.bucketRepository.findAll();
        HashMap<String, List> resultDetail = new HashMap<String, List>();
        HashMap result = new HashMap();
        for (Bucket bucket : buckets) {
            List typeStats = this.fileInfoStatService.fileStatsByType(bucket.getName());
            resultDetail.put(bucket.getName(), typeStats);
            result.put(bucket.getName(), typeStats.stream().map(StatsExtension::getExtension).collect(Collectors.toList()));
        }
        return StdData.ok(detail != false ? resultDetail : result);
    }
}

