/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.third;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.online.base.kmo.KmoFileHandler;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.KmoFileTransformParam;
import com.digiwin.dap.middleware.dmc.online.domain.kmo.KmoFileTransformRequest;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class KmoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(KmoController.class);
    @Autowired
    private KmoFileHandler kmoFileHandler;
    @Autowired
    private FileNodeService fileNodeService;

    @PostMapping(value={"/api/dmc/3rd/kmo/transform/callback"})
    public void callback(@RequestBody Map<String, Object> param) {
        LOGGER.info("kmo transform callback: {}", (Object)JsonUtils.objToJson(param));
    }

    @PostMapping(value={"/api/dmc/3rd/kmo/transform"})
    public StdData<?> transform(@RequestParam String bucket, @RequestParam String fileId, HttpServletRequest request) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
        KmoFileTransformRequest attribute = new KmoFileTransformRequest(request);
        this.kmoFileHandler.transform(bucket, fileInfo, (KmoFileTransformParam)attribute);
        return StdData.ok().build();
    }
}

