/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.api.third;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.online.base.onlyoffice.history.HistoryManager;
import com.digiwin.dap.middleware.dmc.online.domain.onlyoffice.OnlyOfficeEditorRequest;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.documenteditor.Callback;
import com.onlyoffice.model.documenteditor.Config;
import com.onlyoffice.service.documenteditor.callback.CallbackService;
import com.onlyoffice.service.documenteditor.config.ConfigService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OnlyOfficeController {
    @Autowired
    private EnvProperties env;
    @Autowired
    private UrlManager urlManager;
    @Autowired
    private ConfigService configService;
    @Autowired
    private HistoryManager historyManager;
    @Autowired
    private CallbackService callbackService;

    @GetMapping(value={"/api/dmc/3rd/onlyoffice/editor"})
    public String editor(@RequestParam String params, @RequestHeader(value="User-Agent") String agent, Model model) {
        String json = AES.decrypt((String)params, (String)KeyConstant.OTHER);
        OnlyOfficeEditorRequest body = (OnlyOfficeEditorRequest)JsonUtils.jsonToObj((String)json, OnlyOfficeEditorRequest.class);
        UserUtil.setAuthentication((String)body.getUserId(), (String)body.getUserName(), (boolean)body.getIam());
        LocaleContextHolder.setLocale((Locale)body.getLocale());
        body.setAppToken(this.env.getAppToken());
        Config config = this.configService.createConfig(body.getBucket(), body.getFileId(), body.getMode(), agent);
        model.addAttribute("dmcConfig", (Object)body);
        model.addAttribute("config", (Object)config);
        model.addAttribute("documentServerApiUrl", (Object)this.urlManager.getDocumentServerApiUrl());
        return "onlyoffice/editor";
    }

    @GetMapping(value={"/api/dmc/3rd/onlyoffice/history"})
    @ResponseBody
    public ResponseEntity<?> history(@RequestParam String bucket, @RequestParam String fileId) {
        return ResponseEntity.ok((Object)this.historyManager.getHistory(bucket, fileId));
    }

    @GetMapping(value={"/api/dmc/3rd/onlyoffice/history/data"})
    @ResponseBody
    public ResponseEntity<?> historyData(@RequestParam String bucket, @RequestParam String fileId, @RequestParam Integer version) {
        return ResponseEntity.ok((Object)this.historyManager.getHistoryData(bucket, fileId, version));
    }

    @PostMapping(value={"/api/dmc/3rd/onlyoffice/restore"})
    @ResponseBody
    public ResponseEntity<?> restore(@RequestParam String bucket, @RequestParam String fileId, @RequestParam Integer version) {
        try {
            this.historyManager.restore(bucket, fileId, version);
            return ResponseEntity.ok(Collections.singletonMap("success", true));
        }
        catch (Exception e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", e.getMessage());
            result.put("success", false);
            return ResponseEntity.ok(result);
        }
    }

    @ResponseBody
    @PostMapping(value={"/api/dmc/3rd/onlyoffice/callback/{bucket}/{fileId}"})
    public ResponseEntity<?> callback(@PathVariable String bucket, @PathVariable String fileId, @RequestBody Callback body, @RequestHeader(value="Authorization") String authorization) throws Exception {
        this.callbackService.verifyCallback(body, authorization);
        this.callbackService.processCallback(body, bucket, fileId);
        return ResponseEntity.ok(Collections.singletonMap("error", 0));
    }
}

