/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    public static final String TENANT_CUSTOM_REST_TEMPLATE = "tenantCustomRestTemplate";
    @Autowired
    private ObjectMapper objectMapper;

    @Bean(value={"tenantCustomRestTemplate"})
    public RestTemplate tenantCustomRestTemplate() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        for (HttpMessageConverter httpMessageConverter : restTemplate.getMessageConverters()) {
            if (httpMessageConverter instanceof MappingJackson2HttpMessageConverter) {
                ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(this.objectMapper);
            }
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8);
        }
        return restTemplate;
    }
}

