/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.base;

import com.digiwin.dap.middleware.dmc.constant.IndexType;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.DocumentUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public abstract class BaseDatabaseManager<T extends UuIdEntity> {
    private static final CodecRegistry POJO_CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
    private final Map<String, MongoCollection<T>> mongoCollectionCache = new ConcurrentHashMap();
    @Autowired
    private MongoClient mongoClient;

    protected static <T> List<T> toList(FindIterable<T> iterable) {
        ArrayList lists = new ArrayList();
        iterable.forEach(lists::add);
        return lists;
    }

    private MongoDatabase getMongoDatabase(String bucket) {
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(bucket);
        return mongoDatabase.withCodecRegistry(POJO_CODEC_REGISTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoCollection<T> getCollection(String bucket, String collection) {
        if (!this.mongoCollectionCache.containsKey(collection)) {
            BaseDatabaseManager baseDatabaseManager = this;
            synchronized (baseDatabaseManager) {
                if (!this.mongoCollectionCache.containsKey(collection)) {
                    MongoCollection mongoCollection = this.getMongoDatabase(bucket).getCollection(collection, this.getEntityClass());
                    this.checkCreateIndex(mongoCollection);
                    this.mongoCollectionCache.put(collection, mongoCollection);
                }
            }
        }
        return (MongoCollection)this.mongoCollectionCache.get(collection);
    }

    private void checkCreateIndex(MongoCollection<T> collection) {
        if (".fileInfos".equals(this.getCollectionName())) {
            DocumentUtil.createIndex(collection, (String)"fullText", (Object)"text");
            DocumentUtil.createIndex(collection, (String)"createDate", (Object)IndexType.DESC);
            DocumentUtil.createIndex(collection, (String)"directoryId", (Object)IndexType.ASC);
            DocumentUtil.createIndex(collection, (String)"hash", (Object)IndexType.ASC);
        }
    }

    public MongoCollection<T> getAnonymousUserCollection(String bucket, String userName) {
        String collection = ObjectUtils.isEmpty((Object)userName) ? bucket + this.getCollectionName() : userName + this.getCollectionName();
        return this.getCollection(bucket, collection);
    }

    public MongoCollection<T> getLoginUserCollection(String bucket) {
        return this.getLoginUserCollection(bucket, this.getCollectionName());
    }

    public MongoCollection<T> getLoginUserCollection(String bucket, String collectionName) {
        String collection;
        if (!bucket.equals(TenantUtil.getBucketName())) {
            collection = bucket + collectionName;
        } else {
            JwtUser jwtUser = UserUtil.getJwtUser();
            collection = (jwtUser.getIam() != false ? jwtUser.getUserId() : bucket) + collectionName;
        }
        return this.getCollection(bucket, collection);
    }

    protected abstract String getCollectionName();

    protected abstract Class<T> getEntityClass();

    protected T findOne(String bucket, Bson filter) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        Bson sort = Sorts.descending((String[])new String[]{"createDate"});
        return (T)((UuIdEntity)mongoCollection.find(filter).sort(sort).first());
    }

    protected List<T> find(String bucket, Bson filter) {
        return this.find(bucket, filter, null);
    }

    protected List<T> find(String bucket, Bson filter, Bson sort) {
        return this.find(bucket, filter, sort, 0, 0);
    }

    protected List<T> find(String bucket, Bson filter, Bson sort, int skip, int limit) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        FindIterable iterable = mongoCollection.find(filter).sort(sort).skip(skip).limit(limit);
        return BaseDatabaseManager.toList((FindIterable)iterable);
    }

    protected long count(String bucket, Bson filter) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        return mongoCollection.countDocuments(filter);
    }
}

