/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.base;

import com.digiwin.dap.middleware.dmc.dao.base.BaseDatabaseManager;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.dao.base.EntityService;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.UUID;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseEntityService<T extends UuIdEntity>
extends BaseDatabaseManager<T>
implements EntityService<T> {
    protected String getCollectionName() {
        return "." + this.getEntityClass().getSimpleName().toLowerCase();
    }

    protected Class<T> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public String insert(T data) {
        if (data.getId() == null) {
            data.setId(UUID.randomUUID());
        }
        UserUtil.setCreateFields(data);
        MongoCollection mongoCollection = this.getLoginUserCollection(data.getBucket());
        mongoCollection.insertOne(data);
        return data.getId().toString();
    }

    public void deleteById(String bucket, UUID id) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        mongoCollection.deleteOne(Filters.eq((String)"_id", (Object)id));
    }

    public void update(T data) {
        MongoCollection mongoCollection = this.getLoginUserCollection(data.getBucket());
        Bson filter = Filters.eq((String)"_id", (Object)data.getId());
        UserUtil.setModifyFields(data);
        mongoCollection.findOneAndReplace(filter, data);
    }

    public void replace(T data) {
        MongoCollection mongoCollection = this.getLoginUserCollection(data.getBucket());
        Bson filter = Filters.eq((String)"_id", (Object)data.getId());
        mongoCollection.findOneAndReplace(filter, data);
    }

    public T findById(String bucket, String id) {
        return (T)this.findById(bucket, IdUtil.uuid((String)id));
    }

    public T findById(String bucket, UUID id) {
        return (T)this.findOne(bucket, Filters.eq((String)"_id", (Object)id));
    }

    public List<T> findAll(String bucket) {
        return this.find(bucket, BsonUtil.currentTenant());
    }

    public PageData<T> findByPage(String bucket, Page data) {
        Page page = data == null ? Page.empty() : data;
        Bson filter = page.filter();
        long total = super.count(bucket, filter);
        if (total <= 0L) {
            return PageData.zero();
        }
        List list = this.find(bucket, filter, page.sort(), page.skip(), page.limit());
        return PageData.data((long)total, (List)list);
    }

    public boolean existsById(String bucket, UUID id) {
        Bson filter = Filters.eq((String)"_id", (Object)id);
        return this.count(bucket, filter) > 0L;
    }

    public T save(T data) {
        if (data.getId() == null) {
            data.setId(UUID.randomUUID());
        }
        MongoCollection mongoCollection = this.getLoginUserCollection(data.getBucket());
        mongoCollection.insertOne(data);
        return data;
    }
}

