/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.base;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.IndexType;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

/*
 * Exception performing whole class analysis ignored.
 */
public class BsonUtil {
    public static Bson filter(Page page) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        filters.add(BsonUtil.currentTenant());
        filters.add(BsonUtil.normal());
        for (Map.Entry entry : page.getFilters().entrySet()) {
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"_id", (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if (Arrays.stream(BaseField.UUIDS).anyMatch(o -> o.equals(entry.getKey()))) {
                filters.add(Filters.eq((String)((String)entry.getKey()), (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if ("directoryId".equals(entry.getKey()) || "tenantId".equals(entry.getKey())) {
                filters.add(Filters.eq((String)((String)entry.getKey()), entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof String) {
                filters.add(Filters.regex((String)((String)entry.getKey()), (String)String.format("^.*%s.*$", entry.getValue())));
                continue;
            }
            filters.add(Filters.eq((String)((String)entry.getKey()), entry.getValue()));
        }
        for (Map.Entry entry : page.getEqFilters().entrySet()) {
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"_id", (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            filters.add(Filters.eq((String)((String)entry.getKey()), entry.getValue()));
        }
        for (Map.Entry entry : page.getInFilters().entrySet()) {
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.in((String)"_id", (Iterable)((List)entry.getValue()).stream().map(id -> IdUtil.uuid((String)id.toString())).collect(Collectors.toList())));
                continue;
            }
            filters.add(Filters.in((String)((String)entry.getKey()), (Iterable)((Iterable)entry.getValue())));
        }
        for (Map.Entry entry : page.getLikeFilters().entrySet()) {
            filters.add(Filters.regex((String)((String)entry.getKey()), (String)String.format("^.*%s.*$", entry.getValue())));
        }
        return filters.size() == 1 ? (Bson)filters.get(0) : Filters.and(filters);
    }

    public static Bson sort(Map<String, Integer> order) {
        Document sort = new Document();
        for (Map.Entry<String, Integer> entry : order.entrySet()) {
            if ("id".equals(entry.getKey())) {
                if (IndexType.ASC.equals(entry.getValue())) {
                    sort.put("_id", (Object)IndexType.ASC);
                    continue;
                }
                sort.put("_id", (Object)IndexType.DESC);
                continue;
            }
            if (IndexType.ASC.equals(entry.getValue())) {
                sort.put(entry.getKey(), (Object)IndexType.ASC);
                continue;
            }
            sort.put(entry.getKey(), (Object)IndexType.DESC);
        }
        return sort;
    }

    public static Bson sort(int sortType, String type, FileTypeEnum fileType) {
        BsonInt32 typeValue = new BsonInt32(("desc".equals(type) ? IndexType.DESC : IndexType.ASC).intValue());
        BsonDocument document = new BsonDocument();
        if (sortType == 0) {
            document.append(fileType == FileTypeEnum.Directory ? "name" : "fileName", (BsonValue)typeValue);
        } else if (sortType == 1) {
            document.append("createDate", (BsonValue)typeValue);
        } else if (sortType == 2) {
            document.append("sort", (BsonValue)new BsonInt32(IndexType.ASC.intValue()));
        }
        return document;
    }

    public static Map<UUID, Integer> sort(UUID sortId, int sortIndex, List<? extends UuIdEntity> entities) {
        HashMap<UUID, Integer> sortMap = new HashMap<UUID, Integer>();
        int sort = 0;
        for (UuIdEntity uuIdEntity : entities) {
            if (Objects.equals(uuIdEntity.getId(), sortId)) continue;
            if (sort == sortIndex) {
                ++sort;
            }
            if (!Objects.equals(uuIdEntity.getSort(), sort)) {
                sortMap.put(uuIdEntity.getId(), sort);
            }
            ++sort;
        }
        return sortMap;
    }

    public static Bson currentTenant() {
        String tenantId = TenantUtil.getTenant((String)UserUtils.getTenantId());
        if ("default".equals(tenantId) || "99990000".equals(tenantId)) {
            return Filters.empty();
        }
        return Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"tenantId", (Object)"default"), BsonUtil.emptyTenant()});
    }

    public static Bson emptyTenant() {
        return Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"")});
    }

    public static Bson normal() {
        return Filters.or((Bson[])new Bson[]{Filters.eq((String)"deletion", null), Filters.lte((String)"deletion", (Object)0L)});
    }

    public static Bson deleted() {
        return Filters.gt((String)"deletion", (Object)0L);
    }
}

