/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.file.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.impl.BaseFileSystem;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.client.model.Filters;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DirectoryNodeServiceImpl
extends BaseFileSystem<DirInfo>
implements DirectoryNodeService {
    protected String getCollectionName() {
        return ".directories";
    }

    public boolean existsById(String bucket, UUID id) {
        if (IdUtil.isRootDir((UUID)id)) {
            return true;
        }
        return super.existsById(bucket, id);
    }

    public boolean existsByName(String bucket, UUID parentId, String name) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentId", (Object)parentId), Filters.eq((String)"name", (Object)name)});
        return this.count(bucket, filter) > 0L;
    }

    public DirInfo findByName(String bucket, UUID parentId, String name) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentId", (Object)parentId), Filters.eq((String)"name", (Object)name)});
        return (DirInfo)this.findOne(bucket, filter);
    }

    public List<DirInfo> findByParentId(String bucket, UUID parentId) {
        Bson filter = Filters.eq((String)"parentId", (Object)parentId);
        return this.find(bucket, filter);
    }

    public List<DirInfo> findByParentId(String bucket, UUID parentId, Bson sort) {
        Bson filter = Filters.eq((String)"parentId", (Object)parentId);
        return this.find(bucket, filter, sort);
    }

    public List<DirInfo> findByIds(String bucket, List<UUID> ids) {
        Bson filter = Filters.in((String)"_id", ids);
        return this.find(bucket, filter);
    }

    public List<DirInfo> findByNameLike(String bucket, String name) {
        Pattern pattern = Pattern.compile("^.*" + name + ".*$");
        Bson filter = Filters.regex((String)"name", (Pattern)pattern);
        return this.find(bucket, filter);
    }

    public DirInfo findByNamePath(String bucket, UUID parentId, String namePath) {
        String dirName;
        List dirNames = Arrays.stream(namePath.split("/")).filter(StringUtils::hasText).collect(Collectors.toList());
        DirInfo dirInfo = null;
        Iterator iterator = dirNames.iterator();
        while (iterator.hasNext() && (dirInfo = this.findByName(bucket, parentId, dirName = (String)iterator.next())) != null) {
            parentId = dirInfo.getId();
        }
        return dirInfo;
    }

    public DirInfo insertByNamePath(String bucket, UUID parentId, String namePath) {
        List dirNames = Arrays.stream(namePath.split("/")).filter(StringUtils::hasText).collect(Collectors.toList());
        if (dirNames.isEmpty() || dirNames.size() > 4) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_DIR_CREATE_LIMIT, new Object[]{dirNames.size()});
        }
        DirInfo dirInfo = null;
        for (String dirName : dirNames) {
            dirInfo = this.findByName(bucket, parentId, dirName);
            if (dirInfo == null) {
                dirInfo = new DirInfo();
                dirInfo.setParentId(parentId);
                dirInfo.setName(dirName);
                dirInfo.setDisplayName(dirName);
                dirInfo.setBucket(bucket);
                this.insert((UuIdEntity)dirInfo);
            }
            parentId = dirInfo.getId();
        }
        return dirInfo;
    }
}

