/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.file.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.impl.BaseFileSystem;
import com.digiwin.dap.middleware.dmc.domain.v2.FileTree;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FileNodeServiceImpl
extends BaseFileSystem<FileInfo>
implements FileNodeService {
    @Autowired
    private DirectoryNodeService directoryNodeService;

    private static void checkFileBeforeUse(FileInfo fileInfo, String fileInfoId) {
        if (fileInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NONE, new Object[]{fileInfoId});
        }
        if (fileInfo.getCompleted() == null || !fileInfo.getCompleted().booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_UNCOMPLETED);
        }
    }

    protected String getCollectionName() {
        return ".fileInfos";
    }

    @NonNull
    public FileInfo findOne(String bucket, String fileInfoId) {
        FileInfo fileInfo = (FileInfo)this.findById(bucket, fileInfoId);
        FileNodeServiceImpl.checkFileBeforeUse((FileInfo)fileInfo, (String)fileInfoId);
        return fileInfo;
    }

    @NonNull
    public FileInfo findOne(String bucket, String directoryId, String fileName) {
        FileInfo fileInfo = directoryId == null ? this.findByFileName(bucket, fileName) : this.findByFileName(bucket, IdUtil.getDirectoryId((String)directoryId), fileName);
        FileNodeServiceImpl.checkFileBeforeUse((FileInfo)fileInfo, (String)String.format("%s/%s", directoryId, fileName));
        return fileInfo;
    }

    public FileInfo findByFileName(String bucket, String fileName) {
        Bson filter = Filters.eq((String)"fileName", (Object)fileName);
        return (FileInfo)this.findOne(bucket, filter);
    }

    public FileInfo findByFileName(String bucket, String directoryId, String fileName) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"directoryId", (Object)directoryId), Filters.eq((String)"fileName", (Object)fileName)});
        return (FileInfo)this.findOne(bucket, filter);
    }

    public List<FileInfo> findByDirId(String bucket, String directoryId) {
        Bson filter = Filters.eq((String)"directoryId", (Object)directoryId);
        return this.find(bucket, filter);
    }

    public List<FileInfo> findByDirId(String bucket, String directoryId, Bson sort) {
        Bson filter = Filters.eq((String)"directoryId", (Object)directoryId);
        return this.find(bucket, filter, sort);
    }

    public List<FileInfo> findByCondition(String bucket, Bson filter) {
        return this.find(bucket, filter);
    }

    public List<FileInfo> findByCondition(String bucket, Bson filter, Bson sort) {
        return this.find(bucket, filter, sort);
    }

    public List<FileInfo> findByCondition(String bucket, Bson filter, Bson projection, Bson sort) {
        return this.find(bucket, filter, projection, sort, 0, 0);
    }

    public List<FileInfo> findByCondition(String bucket, Bson filter, Bson projection, Bson sort, int skip, int limit) {
        return this.find(bucket, filter, projection, sort, skip, limit);
    }

    public FileTree findFileTree(String bucket, String directoryId, String filePath) {
        DirInfo dir = (DirInfo)this.directoryNodeService.findById(bucket, directoryId);
        if (dir == null) {
            return FileTree.fail((UUID)IdUtil.uuid((String)directoryId), (String)I18nError.FILE_DIR_NONE.getMessage(new Object[]{directoryId}), (boolean)true);
        }
        FileTree dirTree = FileTree.ok((UUID)dir.getId(), (String)dir.getName(), (boolean)true);
        if (filePath != null) {
            dirTree.setFilePath(filePath + File.separator + dir.getName());
        } else {
            dirTree.setFilePath(dir.getName());
        }
        ArrayList<FileTree> fileTrees = new ArrayList<FileTree>();
        List fileInfos = this.findByDirId(bucket, directoryId);
        for (FileInfo fileInfo : fileInfos) {
            FileTree fileTree = FileTree.ok((UUID)fileInfo.getId(), (String)fileInfo.getFileName());
            fileTree.setFilePath(dirTree.getFilePath() + File.separator + fileInfo.getFileName());
            fileTrees.add(fileTree);
        }
        dirTree.setFiles(fileTrees);
        List dirInfos = this.directoryNodeService.findByParentId(bucket, dir.getId());
        for (DirInfo dirInfo : dirInfos) {
            fileTrees.add(this.findFileTree(bucket, dirInfo.getId().toString(), dirTree.getFilePath()));
        }
        return dirTree;
    }

    public List<UUID> findByIds(String bucket, List<UUID> ids) {
        Bson filter = Filters.in((String)"_id", ids);
        List fileInfos = this.find(bucket, filter, Projections.include((String[])new String[]{"_id"}), null, 0, 0);
        return fileInfos.stream().map(UuIdEntity::getId).collect(Collectors.toList());
    }
}

