/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.impl;

import com.digiwin.dap.middleware.dmc.dao.BackupCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BaseEntityService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.Backup;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.storage.FileStorage;
import com.digiwin.dap.middleware.dmc.storage.FileStorageFactory;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BackupCrudServiceImpl
extends BaseEntityService<Backup>
implements BackupCrudService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private FileStorageFactory fileStorageFactory;

    protected String getCollectionName() {
        return ".backups";
    }

    public PageData<Backup> findByPage(String bucket, Page data) {
        Page page = data == null ? Page.empty() : data;
        Bson filter = this.filter(page);
        long total = super.count(bucket, filter);
        if (total <= 0L) {
            return PageData.zero();
        }
        List list = this.find(bucket, filter, page.sort(), page.skip(), page.limit());
        return PageData.data((long)total, (List)list);
    }

    private Bson filter(Page page) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        for (Map.Entry entry : page.getFilters().entrySet()) {
            if (ObjectUtils.isEmpty(entry.getValue())) continue;
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"_id", (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if ("backupId".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"backupId", (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if (!"fileName".equals(entry.getKey())) continue;
            filters.add(Filters.regex((String)((String)entry.getKey()), (String)String.format("^.*%s.*$", entry.getValue())));
        }
        int size = filters.size();
        if (size == 0) {
            return new BsonDocument();
        }
        if (size == 1) {
            return (Bson)filters.get(0);
        }
        return Filters.and(filters);
    }

    public Backup findByFileId(String bucket, UUID backupId, Integer version) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"backupId", (Object)backupId), Filters.eq((String)"version", (Object)version)});
        return (Backup)this.findOne(bucket, filter);
    }

    public List<Backup> findByFileId(String bucket, UUID backupId) {
        Bson filter = Filters.eq((String)"backupId", (Object)backupId);
        Bson sort = Sorts.ascending((String[])new String[]{"createDate"});
        return this.find(bucket, filter, sort);
    }

    public List<Backup> findByFileId(String bucket, UUID backupId, int skip, int limit) {
        Bson filter = Filters.eq((String)"backupId", (Object)backupId);
        Bson sort = Sorts.descending((String[])new String[]{"createDate"});
        return this.find(bucket, filter, sort, skip, limit);
    }

    public void addBackup(String bucket, FileInfo fileInfo) {
        Bson filter = Filters.eq((String)"backupId", (Object)fileInfo.getId());
        Backup latest = (Backup)this.findOne(bucket, filter);
        Backup entity = new Backup();
        entity.setBackupId(fileInfo.getId());
        entity.setVersion(Integer.valueOf(latest == null ? 1 : (latest.getVersion() == null ? 1 : latest.getVersion() + 1)));
        entity.setFileName(fileInfo.getFileName());
        entity.setSize(fileInfo.getSize());
        entity.setExtension(fileInfo.getExtension());
        entity.setFileId(fileInfo.getFileId());
        entity.setFilePath(fileInfo.getFilePath());
        entity.setStorage(fileInfo.getStorage());
        entity.setTenantId(fileInfo.getTenantId());
        entity.setBucket(fileInfo.getBucket());
        this.insert((UuIdEntity)entity);
        Bucket buck = this.bucketRepository.findByName(bucket);
        int buckUp = buck == null || buck.getBackup() == null || buck.getBackup() < 0 ? (this.envProperties.isCoa() ? 10 : 3) : buck.getBackup();
        List backups = this.findByFileId(bucket, entity.getBackupId(), buckUp, 0);
        for (Backup backup : backups) {
            this.delBackup(bucket, backup);
        }
    }

    public void delBackup(String bucket, UUID id) {
        Backup backup = (Backup)this.findById(bucket, id);
        this.delBackup(bucket, backup);
    }

    private void delBackup(String bucket, Backup backup) {
        FileStorage fileStorage = this.fileStorageFactory.getFileStorage(bucket, (FileInfo)backup);
        fileStorage.deleteFile((FileInfo)backup);
        this.deleteById(bucket, backup.getId());
    }
}

