/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.impl;

import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BaseEntityService;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DirectoryCrudServiceImpl
extends BaseEntityService<DirInfo>
implements DirectoryCrudService {
    protected String getCollectionName() {
        return ".directories";
    }

    public PageData<DirInfo> findByPage(String bucket, Page data) {
        Page page = data == null ? Page.empty() : data;
        Bson filter = this.filter(page);
        long total = super.count(bucket, filter);
        if (total <= 0L) {
            return PageData.zero();
        }
        List list = this.find(bucket, filter, page.sort(), page.skip(), page.limit());
        return PageData.data((long)total, (List)list);
    }

    private Bson filter(Page page) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        Object deletion = page.getFilters().get("deletion");
        if (ObjectUtils.isEmpty(deletion)) {
            filters.add(BsonUtil.normal());
        } else if (deletion instanceof Boolean && ((Boolean)deletion).booleanValue()) {
            filters.add(BsonUtil.deleted());
        }
        for (Map.Entry entry : page.getFilters().entrySet()) {
            if (ObjectUtils.isEmpty(entry.getValue())) continue;
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"_id", (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if ("parentId".equals(entry.getKey())) {
                filters.add(Filters.eq((String)((String)entry.getKey()), (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if (!"name".equals(entry.getKey())) continue;
            filters.add(Filters.regex((String)((String)entry.getKey()), (String)String.format("^.*%s.*$", entry.getValue())));
        }
        int size = filters.size();
        if (size == 0) {
            return new BsonDocument();
        }
        if (size == 1) {
            return (Bson)filters.get(0);
        }
        return Filters.and(filters);
    }

    public List<DirInfo> findByParentId(String bucket, UUID parentId) {
        Bson filter = Filters.eq((String)"parentId", (Object)parentId);
        return this.find(bucket, filter);
    }

    public List<DirInfo> findDeletedByParentId(String bucket, UUID parentId) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentId", (Object)parentId), BsonUtil.deleted()});
        return this.find(bucket, filter);
    }
}

