/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.impl;

import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BaseEntityService;
import com.digiwin.dap.middleware.dmc.dao.base.BsonUtil;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.domain.v2.Page;
import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.serializer.Constants;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FileInfoCrudServiceImpl
extends BaseEntityService<FileInfo>
implements FileInfoCrudService {
    protected String getCollectionName() {
        return ".fileInfos";
    }

    public PageData<FileInfo> findByPage(String bucket, Page data) {
        Page page = data == null ? Page.empty() : data;
        Bson filter = this.filter(page);
        long total = super.count(bucket, filter);
        if (total <= 0L) {
            return PageData.zero();
        }
        List list = this.find(bucket, filter, page.sort(), page.skip(), page.limit());
        return PageData.data((long)total, (List)list);
    }

    private Bson filter(Page page) {
        ArrayList<Object> filters = new ArrayList<Object>();
        Object deletion = page.getFilters().get("deletion");
        if (ObjectUtils.isEmpty(deletion)) {
            filters.add(BsonUtil.normal());
        } else if (deletion instanceof Boolean && ((Boolean)deletion).booleanValue()) {
            filters.add(BsonUtil.deleted());
        }
        for (Map.Entry entry : page.getFilters().entrySet()) {
            if (ObjectUtils.isEmpty(entry.getValue())) continue;
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"_id", (Object)IdUtil.uuid((String)entry.getValue().toString())));
                continue;
            }
            if ("directoryId".equals(entry.getKey()) || "tenantId".equals(entry.getKey())) {
                filters.add(Filters.eq((String)((String)entry.getKey()), entry.getValue()));
                continue;
            }
            if ("fileName".equals(entry.getKey())) {
                filters.add(Filters.regex((String)((String)entry.getKey()), (String)String.format("^.*%s.*$", entry.getValue())));
                continue;
            }
            if ("createBeginDate".equals(entry.getKey())) {
                filters.add(Filters.gte((String)"createDate", (Object)LocalDateTime.parse(entry.getValue().toString(), Constants.DATETIME_FORMATTER)));
                continue;
            }
            if ("createEndDate".equals(entry.getKey())) {
                filters.add(Filters.lt((String)"createDate", (Object)LocalDateTime.parse(entry.getValue().toString(), Constants.DATETIME_FORMATTER)));
                continue;
            }
            if ("completed".equals(entry.getKey())) {
                filters.add(Filters.eq((String)((String)entry.getKey()), entry.getValue()));
                continue;
            }
            if ("empty".equals(entry.getKey())) {
                boolean empty = (Boolean)entry.getValue();
                filters.add(empty ? BsonUtil.emptyTenant() : BsonUtil.currentTenant());
                continue;
            }
            if ("storage".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"storage", entry.getValue()));
                continue;
            }
            if ("storageEmpty".equals(entry.getKey()) && Boolean.TRUE.equals(entry.getValue())) {
                filters.add(Filters.eq((String)"storage", null));
                continue;
            }
            if (!"migration".equals(entry.getKey()) || !Boolean.TRUE.equals(entry.getValue())) continue;
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"storage", (Object)StorageEnum.MongoDB), Filters.eq((String)"storage", null)}), Filters.eq((String)"migration", null)});
            filters.add(filter);
        }
        for (Map.Entry entry : page.getInFilters().entrySet()) {
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.in((String)"_id", (Iterable)IdUtil.validUuid((List)((List)entry.getValue()))));
                continue;
            }
            if (entry.getValue() instanceof List) {
                filters.add(Criteria.where((String)((String)entry.getKey())).in((Collection)((List)entry.getValue())).getCriteriaObject());
                continue;
            }
            filters.add(Criteria.where((String)((String)entry.getKey())).in((Collection)entry.getValue()).getCriteriaObject());
        }
        int size = filters.size();
        if (size == 0) {
            return new BsonDocument();
        }
        if (size == 1) {
            return (Bson)filters.get(0);
        }
        return Filters.and(filters);
    }

    public List<FileInfo> findDeletedByDirId(String bucket, UUID dirId) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"directoryId", (Object)dirId.toString()), BsonUtil.deleted()});
        return this.find(bucket, filter);
    }

    public long count(String bucket, UUID id, ObjectId fileId) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.ne((String)"_id", (Object)id), Filters.eq((String)"fileId", (Object)fileId)});
        return this.count(bucket, filter);
    }

    public FileInfo findFirst(String bucket, UUID id, ObjectId fileId) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.ne((String)"_id", (Object)id), Filters.eq((String)"fileId", (Object)fileId), Filters.ne((String)"filePath", null)});
        return (FileInfo)this.findOne(bucket, filter);
    }

    public void visits(String bucket, UUID id) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        mongoCollection.updateOne(Filters.eq((String)"_id", (Object)id), Updates.inc((String)"visits", (Number)1));
    }

    public List<FileInfo> findUnMigration(String bucket, Integer pageNumber, Integer pageSize) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"storage", (Object)StorageEnum.MongoDB), Filters.eq((String)"storage", null)}), Filters.eq((String)"migration", null)});
        return this.find(bucket, filter, null, pageNumber.intValue(), pageSize.intValue());
    }

    public UpdateResult migrationSwitch(String bucket, StorageEnum storage) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"storage", (Object)StorageEnum.MongoDB), Filters.eq((String)"storage", null)}), Filters.eq((String)"migration", (Object)Boolean.TRUE)});
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        return mongoCollection.updateMany(filter, Updates.set((String)"storage", (Object)storage));
    }

    public UpdateResult migrationSwitchRestore(String bucket, StorageEnum storage) {
        Bson filter = Filters.eq((String)"migration", (Object)Boolean.TRUE);
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        return mongoCollection.updateMany(filter, Updates.set((String)"storage", (Object)StorageEnum.MongoDB));
    }

    public UpdateResult migrationSwitchReset(String bucket) {
        Bson filter = Filters.eq((String)"migration", (Object)Boolean.TRUE);
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        return mongoCollection.updateMany(filter, Updates.unset((String)"migration"));
    }
}

