/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.dao.impl;

import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.dao.base.BaseEntityService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.enumeration.ShareType;
import com.digiwin.dap.middleware.dmc.domain.v2.BatchFid;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.service.business.FileService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.serializer.Constants;
import com.digiwin.dap.middleware.util.UserUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareCrudServiceImpl
extends BaseEntityService<SharedFile>
implements ShareCrudService {
    @Autowired
    private FileService fileService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private FileNodeService fileNodeService;

    protected String getCollectionName() {
        return ".shared_files";
    }

    public void deleteByFileId(String bucket, String fileInfoId) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        mongoCollection.deleteMany(Filters.eq((String)"fileId", (Object)fileInfoId));
    }

    public long deleteByIdIn(String bucket, Collection<UUID> ids) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        DeleteResult deleteResult = mongoCollection.deleteMany(Filters.in((String)"_id", ids));
        return deleteResult.getDeletedCount();
    }

    public void allowCount(String bucket, UUID id) {
        MongoCollection mongoCollection = this.getLoginUserCollection(bucket);
        mongoCollection.updateOne(Filters.eq((String)"_id", (Object)id), Updates.inc((String)"allowCount", (Number)-1));
    }

    public SharedFile shareFile(String bucket, String fileInfoId) {
        return this.shareFile(bucket, fileInfoId, 0L);
    }

    public SharedFile shareFile(String bucket, String fileInfoId, long expireDay) {
        FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileInfoId);
        SharedFile sharedFile = new SharedFile();
        sharedFile.setId(UUID.randomUUID());
        sharedFile.setUserId(UserUtils.getUserId());
        sharedFile.setUserName(UserUtils.getUserName());
        sharedFile.setType(ShareType.One);
        sharedFile.setFileId(fileInfo.getId().toString());
        sharedFile.setFileName(fileInfo.getFileName());
        sharedFile.setUrl(this.getShareUrl(bucket, sharedFile.getId()));
        if (expireDay > 0L) {
            sharedFile.setExpired(true);
            sharedFile.setExpireDate(LocalDateTime.now().plusDays(expireDay).format(Constants.DATETIME_FORMATTER));
        }
        sharedFile.setPubic(true);
        sharedFile.setFileIds(Collections.singletonList(sharedFile.getFileId()));
        sharedFile.setShareFileDate(LocalDateTime.now().format(Constants.DATETIME_FORMATTER));
        sharedFile.setBucket(bucket);
        this.insert((UuIdEntity)sharedFile);
        return sharedFile;
    }

    public SharedFile shareFile(String bucket, BatchFid batchFid) {
        this.fileCheck(bucket, batchFid);
        SharedFile sharedFile = new SharedFile();
        sharedFile.setId(UUID.randomUUID());
        sharedFile.setUserId(UserUtils.getUserId());
        sharedFile.setUserName(UserUtils.getUserName());
        if (batchFid.oneFile()) {
            FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, (String)batchFid.getFileIds().get(0));
            sharedFile.setType(ShareType.One);
            sharedFile.setFileId(fileInfo.getId().toString());
            sharedFile.setFileName(fileInfo.getFileName());
        } else {
            sharedFile.setType(ShareType.Mix);
        }
        sharedFile.setUrl(this.getShareUrl(bucket, sharedFile.getId()));
        if (batchFid.getExpireDate() != null) {
            sharedFile.setExpired(true);
            sharedFile.setExpireDate(batchFid.getExpireDate().format(Constants.DATETIME_FORMATTER));
        }
        sharedFile.setAllowCount(batchFid.getAllowCount());
        sharedFile.setDeleteFile(batchFid.getDeleteFile());
        sharedFile.setPubic(true);
        sharedFile.setFileIds(batchFid.getFileIds());
        sharedFile.setDirIds(batchFid.getDirIds());
        sharedFile.setShareFileDate(LocalDateTime.now().format(Constants.DATETIME_FORMATTER));
        sharedFile.setBucket(bucket);
        this.insert((UuIdEntity)sharedFile);
        return sharedFile;
    }

    private void fileCheck(String bucket, BatchFid batchFid) {
        for (String fileId : batchFid.getFileIds()) {
            this.fileNodeService.findOne(bucket, fileId);
        }
        for (String dirId : batchFid.getDirIds()) {
            this.fileService.dirOpCheck(bucket, IdUtil.uuid((String)dirId));
        }
    }

    public SharedFile getSharedFile(String bucket, String id) {
        boolean expire;
        SharedFile sharedFile = (SharedFile)this.findById(bucket, id);
        if (sharedFile == null) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_SHARED_NONE, new Object[]{id});
        }
        if (sharedFile.getExpireDate() != null && (expire = LocalDateTime.now().isAfter(LocalDateTime.parse(sharedFile.getExpireDate(), Constants.DATETIME_FORMATTER)))) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_SHARED_EXPIRE, new Object[]{id, sharedFile.getExpireDate()});
        }
        if (sharedFile.getAllowCount() != null && sharedFile.getAllowCount() <= 0) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_SHARED_EXPIRE, new Object[]{id, sharedFile.getAllowCount()});
        }
        return sharedFile;
    }

    public List<SharedFile> getMyShareFile(String bucket) {
        Bson filter = Filters.in((String)"userId", (Object[])new String[]{UserUtils.getUserId()});
        return this.find(bucket, filter);
    }

    public List<SharedFile> getShareFileByFileId(String bucket, String fileId) {
        Bson filter = Filters.in((String)"fileId", (Object[])new String[]{fileId});
        Bson sort = Sorts.descending((String[])new String[]{"createDate"});
        return this.find(bucket, filter, sort);
    }

    private String getShareUrl(String bucket, UUID shareId) {
        return String.format("%s/api/dmc/v2/file/%s/share/%s", this.envProperties.getDmcUri(), bucket, shareId);
    }
}

