/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.domain;

import com.digiwin.dap.middleware.dmc.domain.ImageInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bson.Document;

public class ImageFile {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private UUID fileId;
    private String fileName;
    private String directoryId;
    private String displayName;
    private String description;
    private String extension;
    private String contentType;
    private long size;
    private String uploadDate;
    private String shareUrl;
    private String shareDate;
    private Document property = new Document();

    public ImageFile() {
    }

    public ImageFile(FileInfo fileInfo, SharedFile sharedFile, Document property) {
        this.copy(fileInfo);
        this.property = property;
        this.shareUrl = sharedFile.getUrl();
        this.shareDate = sharedFile.getShareFileDate();
    }

    public void copy(FileInfo fileInfo, SharedFile sharedFile, boolean share) {
        this.copy(fileInfo);
        this.property = new Document();
        if (share) {
            this.shareUrl = sharedFile.getUrl();
            this.shareDate = sharedFile.getShareFileDate();
        }
    }

    public void copy(FileInfo fileInfo, String sharedUrl, ImageInfo imageInfo) {
        this.copy(fileInfo);
        this.property = new Document().append("width", (Object)imageInfo.getWidth()).append("height", (Object)imageInfo.getHeight());
        if (imageInfo.isShare()) {
            this.shareUrl = sharedUrl;
            this.shareDate = sdf.format(new Date());
        }
    }

    public void copy(FileInfo fileInfo, SharedFile sharedFile, ImageInfo imageInfo) {
        this.copy(fileInfo);
        this.property = new Document().append("width", (Object)imageInfo.getWidth()).append("height", (Object)imageInfo.getHeight());
        if (imageInfo.isShare()) {
            this.shareUrl = sharedFile.getUrl();
            this.shareDate = sharedFile.getShareFileDate();
        }
    }

    public void copy(FileInfo fileInfo) {
        this.fileId = fileInfo.getId();
        this.fileName = fileInfo.getFileName();
        this.directoryId = fileInfo.getDirectoryId();
        this.displayName = fileInfo.getDisplayName();
        this.extension = fileInfo.getExtension();
        this.contentType = fileInfo.getContentType();
        this.size = fileInfo.getSize();
        this.uploadDate = sdf.format(fileInfo.getUploadDate());
    }

    public UUID getFileId() {
        return this.fileId;
    }

    public void setFileId(UUID fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getUploadDate() {
        return this.uploadDate;
    }

    public void setUploadDate(String uploadDate) {
        this.uploadDate = uploadDate;
    }

    public String getShareUrl() {
        return this.shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getShareDate() {
        return this.shareDate;
    }

    public void setShareDate(String shareDate) {
        this.shareDate = shareDate;
    }

    public Document getProperty() {
        return this.property;
    }

    public void setProperty(Document property) {
        this.property = property;
    }
}

