/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.domain.enumeration;

import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;

public class MimeType {
    public static final String VIDEO_MP4 = "video/mp4";
    public static final String VIDEO_WEBM = "video/webm";
    public static final String VIDEO_OGG = "video/ogg";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_BMP = "image/bmp";
    public static final String IMAGE_GIF = "image/gif";

    public static boolean isVideo(String type) {
        return type != null && (type.contains(VIDEO_MP4) || type.contains(VIDEO_WEBM) || type.contains(VIDEO_OGG));
    }

    public static boolean isImage(String type) {
        return type != null && (type.contains(IMAGE_JPEG) || type.contains(IMAGE_PNG) || type.contains(IMAGE_BMP) || type.contains(IMAGE_GIF));
    }

    public static MediaType parse(String mediaType) {
        try {
            return MediaType.parseMediaType((String)mediaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }

    public static String getContentType(String fileName) {
        return MediaTypeFactory.getMediaType((String)fileName).orElse(MediaType.APPLICATION_OCTET_STREAM).toString();
    }

    public static boolean isZip(String extension) {
        return "zip".equals(extension) || "tgz".equals(extension);
    }
}

