/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.entity.objectid;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.commons.crypto.constant.KeySizeEnum;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.util.DataUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="buckets")
public class Bucket
extends ObIdEntity {
    @Field(value="Name")
    private String name;
    @Field(value="Description")
    private String description;
    @Field(value="Owner")
    private String owner;
    private String appId;
    private boolean check;
    private boolean force;
    private boolean shrink;
    private boolean test;
    private boolean hash;
    private Integer retain;
    private Integer backup;
    private List<String> owners;
    private List<String> admins;
    private long quotaSize = DataUtil.GB;
    private long totalSize;
    private long totalCount;
    private long fileSize;
    private long fileCount;
    private long deleteSize;
    private long deleteCount;
    @Field(value="emails")
    private List<String> emails;
    @Field(value="publicKey")
    private String publicKey;
    @JsonIgnore
    @Field(value="privateKey")
    private String privateKey;
    @Field(value="encryptedStorage")
    private Boolean encryptedStorage;
    @JsonIgnore
    @Field(value="aesKey")
    private String aesKey;
    private Map<String, String> yozoView = new HashMap();
    private Long count1;
    private Long count2;
    @Field(value="KeyType")
    private String keyType = "objectid";
    @Field(value="StorageName")
    private String storageName = "mongoDefault";
    @Field(value="ApiUrl")
    private String apiUrl;
    @Field(value="tenantId")
    private String tenantId;
    @Field(value="VersionNum")
    private String versionNum;

    public Bucket() {
        this.owners = new ArrayList();
        this.admins = new ArrayList();
    }

    public void flushKey() {
        KeyPair keyPair = RSA.generateKeyPair((int)KeySizeEnum.RSA_1024.getValue());
        String publicKey = Base64.encode((byte[])keyPair.getPublic().getEncoded());
        String privateKey = Base64.encode((byte[])keyPair.getPrivate().getEncoded());
        this.setPrivateKey(privateKey);
        this.setPublicKey(publicKey);
        this.setAesKey(Base64.encode((byte[])AES.generateKey((int)KeySizeEnum.AES_256.getValue())));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isShrink() {
        return this.shrink;
    }

    public void setShrink(boolean shrink) {
        this.shrink = shrink;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public boolean isHash() {
        return this.hash;
    }

    public void setHash(boolean hash) {
        this.hash = hash;
    }

    public Integer getRetain() {
        return this.retain;
    }

    public void setRetain(Integer retain) {
        this.retain = retain;
    }

    public Integer getBackup() {
        return this.backup;
    }

    public void setBackup(Integer backup) {
        this.backup = backup;
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public void setOwners(List<String> owners) {
        this.owners = owners;
    }

    public List<String> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<String> admins) {
        this.admins = admins;
    }

    public long getQuotaSize() {
        return this.quotaSize;
    }

    public void setQuotaSize(long quotaSize) {
        this.quotaSize = quotaSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public long getDeleteSize() {
        return this.deleteSize;
    }

    public void setDeleteSize(long deleteSize) {
        this.deleteSize = deleteSize;
    }

    public long getDeleteCount() {
        return this.deleteCount;
    }

    public void setDeleteCount(long deleteCount) {
        this.deleteCount = deleteCount;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public Boolean isEncryptedStorage() {
        return this.encryptedStorage;
    }

    public void setEncryptedStorage(Boolean encryptedStorage) {
        this.encryptedStorage = encryptedStorage;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public Map<String, String> getYozoView() {
        return this.yozoView;
    }

    public void setYozoView(Map<String, String> yozoView) {
        this.yozoView = yozoView;
    }

    public Long getCount1() {
        return this.count1;
    }

    public void setCount1(Long count1) {
        this.count1 = count1;
    }

    public Long getCount2() {
        return this.count2;
    }

    public void setCount2(Long count2) {
        this.count2 = count2;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getVersionNum() {
        return this.versionNum;
    }

    public void setVersionNum(String versionNum) {
        this.versionNum = versionNum;
    }

    public String toString() {
        return this.name + "(" + this.owner + ")";
    }
}

