/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.entity.uuid;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.constant.I18nError;
import com.digiwin.dap.middleware.dmc.domain.enumeration.OnlineEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.StorageEnum;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Date;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;
import org.springframework.util.ObjectUtils;

public class FileInfo
extends UuIdEntity {
    public static final String COLLECTION_NAME = ".fileInfos";
    private String fileName;
    private String displayName;
    private String description;
    private String tag;
    private long size;
    private String extension;
    private String contentType;
    private Boolean completed;
    private LocalDateTime expireDate;
    private Document metadata = new Document();
    private String directoryId;
    private String directoryName;
    private ObjectId fileId;
    private String filePath;
    private String hash;
    @JsonIgnore
    private String fullText;
    private String bucketName;
    private long totalSize;
    private Date uploadDate;
    private long visits;
    private LocalDateTime coverDate;
    private StorageEnum storage;
    private OnlineEnum online;
    private Boolean migration;
    @Transient
    private boolean needModerator = false;
    private boolean encryptFile = false;

    public static FileInfo get(String fileJson) {
        FileInfo fileInfo;
        try {
            String decode = URLDecoder.decode(fileJson, StandardCharsets.UTF_8.name());
            fileInfo = (FileInfo)JsonUtils.createDmcObjectMapper().readValue(decode, FileInfo.class);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_UPLOAD_PARAM_FAIL);
        }
        if (ObjectUtils.isEmpty((Object)fileInfo.fileName)) {
            throw new BusinessException((ErrorHandler)I18nError.FILE_NAME_NONE);
        }
        return fileInfo;
    }

    @Deprecated
    public static FileInfo dual(String fileName, String fileId) {
        FileInfo dualFileInfo = new FileInfo();
        dualFileInfo.setId(BaseField.EMPTY_UUID);
        dualFileInfo.setFileName(fileName);
        if (fileId != null) {
            dualFileInfo.setFileId(new ObjectId(fileId));
        }
        return dualFileInfo;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public LocalDateTime getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }

    public Document getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Document metadata) {
        this.metadata = metadata;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public ObjectId getFileId() {
        return this.fileId;
    }

    public void setFileId(ObjectId fileId) {
        this.fileId = fileId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    @Deprecated
    public String getBucketName() {
        return this.bucketName;
    }

    @Deprecated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Deprecated
    public long getTotalSize() {
        return this.totalSize;
    }

    @Deprecated
    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Deprecated
    public Date getUploadDate() {
        return this.uploadDate;
    }

    @Deprecated
    public void setUploadDate(Date uploadDate) {
        this.uploadDate = uploadDate;
    }

    public long getVisits() {
        return this.visits;
    }

    public void setVisits(long visits) {
        this.visits = visits;
    }

    public LocalDateTime getCoverDate() {
        return this.coverDate;
    }

    public void setCoverDate(LocalDateTime coverDate) {
        this.coverDate = coverDate;
    }

    public StorageEnum getStorage() {
        return this.storage;
    }

    public void setStorage(StorageEnum storage) {
        this.storage = storage;
    }

    public OnlineEnum getOnline() {
        return this.online;
    }

    public void setOnline(OnlineEnum online) {
        this.online = online;
    }

    public Boolean getMigration() {
        return this.migration;
    }

    public void setMigration(Boolean migration) {
        this.migration = migration;
    }

    public boolean isNeedModerator() {
        return this.needModerator;
    }

    public void setNeedModerator(boolean needModerator) {
        this.needModerator = needModerator;
    }

    public boolean isEncryptFile() {
        return this.encryptFile;
    }

    public void setEncryptFile(boolean encryptFile) {
        this.encryptFile = encryptFile;
    }

    public FileInfo clone() {
        try {
            return (FileInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return super.getSort() + "[" + super.getId() + "]" + this.fileName;
    }
}

