/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.ObIdEntity;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.CoaUser;
import com.digiwin.dap.middleware.dmc.obsolete.entity.UserIam;
import com.digiwin.dap.middleware.dmc.obsolete.repository.UserIamRepository;
import com.digiwin.dap.middleware.dmc.obsolete.service.UserIamService;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class CoaController {
    @Autowired
    private UserIamService userIamService;
    @Autowired
    private BucketRepository bucketRepository;
    @Autowired
    private UserIamRepository userIamRepository;

    @RoleAuthorize
    @PostMapping(value={"/coa/sysAdminDeleteGroup/bucketName/{bucket}"})
    public ResponseEntity<?> deleteGroup(@PathVariable(value="bucket") String bucket) {
        if (!this.bucketRepository.existsByName(bucket)) {
            throw new BusinessException("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728\uff1a" + bucket);
        }
        this.userIamService.deleteBucket(bucket, UserUtil.getTenant());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize
    @PostMapping(value={"/coa/modifyBucketName/bucketName/{bucket}"})
    public ResponseEntity<?> modifyBucket(@PathVariable(value="bucket") String bucket, @RequestBody Map<String, String> map) {
        Bucket dbBucket = this.bucketRepository.findByName(bucket);
        if (dbBucket == null) {
            throw new BusinessException("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728\uff1a" + bucket);
        }
        dbBucket.setDescription(map.get("bucketDescription"));
        this.bucketRepository.update((ObIdEntity)dbBucket);
        return ResponseEntity.ok((Object)dbBucket);
    }

    @GetMapping(value={"/coa/findMyGroup"})
    public ResponseEntity<?> findMyGroup() {
        JwtUser jwtUser = UserUtil.getJwtUser();
        String username = jwtUser.getUserId();
        List buckets = this.bucketRepository.findByOwner(username);
        List iamUsers = this.userIamRepository.findByTenantIdAndUserId(UserUtil.getTenant(), username);
        if (!iamUsers.isEmpty()) {
            List names = iamUsers.stream().map(UserIam::getBucketName).collect(Collectors.toList());
            List iamUserBuckets = this.bucketRepository.findByNames(names);
            buckets.addAll(iamUserBuckets);
        }
        return ResponseEntity.ok((Object)buckets);
    }

    @RoleAuthorize
    @PostMapping(value={"/coa/sysAdminDeleteUsers/bucketName/{bucket}"})
    public StdData<?> deleteUsers(@PathVariable(value="bucket") String bucket, @RequestBody List<String> userIds) {
        if (!this.bucketRepository.existsByName(bucket)) {
            throw new BusinessException("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728\uff1a" + bucket);
        }
        return StdData.ok((Object)this.userIamRepository.deleteUsers(bucket, UserUtil.getTenant(), userIds));
    }

    @RoleAuthorize
    @PostMapping(value={"/coa/sysAdminAddUsers/bucketName/{bucket}"})
    public ResponseEntity<?> addUsers(@PathVariable(value="bucket") String bucket, @RequestBody List<CoaUser> body) {
        if (!this.bucketRepository.existsByName(bucket)) {
            throw new BusinessException("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728\uff1a" + bucket);
        }
        String tenantId = UserUtil.getTenant();
        String userName = UserUtils.getUserId();
        return ResponseEntity.ok((Object)this.userIamService.insert(body, tenantId, userName, bucket));
    }

    @RoleAuthorize
    @GetMapping(value={"/coa/findUsers/bucketName/{bucket}"})
    public ResponseEntity<?> findUsers(@PathVariable(value="bucket") String bucket) {
        if (!this.bucketRepository.existsByName(bucket)) {
            throw new BusinessException("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728\uff1a" + bucket);
        }
        List iamUsers = this.userIamRepository.findByTenantIdAndBucketName(UserUtil.getTenant(), bucket);
        ArrayList<CoaUser> coaUsers = new ArrayList<CoaUser>();
        for (UserIam userIam : iamUsers) {
            CoaUser user = new CoaUser(userIam.getUserId(), userIam.getUserName());
            coaUsers.add(user);
        }
        return ResponseEntity.ok(coaUsers);
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/coa/findAllUser"})
    public ResponseEntity<?> getAllUser() {
        List iamUsers = this.userIamRepository.findAll();
        return ResponseEntity.ok((Object)iamUsers);
    }

    @RoleAuthorize(owner=false, admin=true)
    @GetMapping(value={"/coa/findAllUser/{bucket}"})
    public ResponseEntity<?> getAllUserByBucket(@PathVariable(value="bucket") String bucket) {
        List iamUsers = this.userIamRepository.findByBucketName(bucket);
        return ResponseEntity.ok((Object)iamUsers);
    }
}

