/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import cn.hutool.core.codec.Base64;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.domain.BatchDownFileVO;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class DownloadFileController {
    @Autowired
    private FileDownloadService fileDownloadService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private DirectoryNodeService directoryNodeService;

    @Deprecated
    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/batch/downfile", "/myresources/batch/downfile"})
    public ResponseEntity<?> batchDownload(@PathVariable(required=false) String bucket, @RequestBody @Validated BatchDownFileVO batchDownFileVO) {
        bucket = TenantUtil.getBucketName((String)bucket);
        ArrayList resultList = new ArrayList();
        try {
            String path = batchDownFileVO.getDirPath();
            String dirId = StringUtils.isEmpty((Object)path) ? "00000000-0000-0000-0000-000000000000" : this.getDirId("00000000-0000-0000-0000-000000000000", path, bucket);
            for (String fileName : batchDownFileVO.getFileNames()) {
                HashMap<String, String> fileMap = new HashMap<String, String>();
                FileInfo fileInfo = this.fileNodeService.findByFileName(bucket, dirId, fileName);
                if (fileInfo == null) continue;
                byte[] fileBytes = this.fileDownloadService.downloadToBytes(bucket, String.valueOf(fileInfo.getId()));
                String content = Base64.encode((byte[])fileBytes).replace("\r", "").replace("\n", "");
                fileMap.put("name", fileInfo.getFileName());
                fileMap.put("content", content);
                resultList.add(fileMap);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return ResponseEntity.ok((Object)StdData.ok(resultList));
    }

    private String getDirId(String parentId, String path, String bucketName) {
        String firstDirName = path.contains(File.separator) ? path.substring(0, path.indexOf(File.separator)) : path;
        DirInfo dirInfo = this.directoryNodeService.findByName(bucketName, IdUtil.getDirId((String)parentId), firstDirName);
        if (dirInfo == null) {
            return parentId;
        }
        return this.getDirId(String.valueOf(dirInfo.getId()), path.substring(path.indexOf(File.separator) + 1), bucketName);
    }
}

