/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.domain.enumeration.LogType;
import com.digiwin.dap.middleware.dmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.dmc.service.login.token.DriveTokenService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuth;
import com.digiwin.dap.middleware.dmc.support.auth.domain.DriveAuthItem;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.StringUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.exception.AppError;
import java.util.Collections;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class DriveTokenController {
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private DriveTokenService driveTokenService;

    private static ResponseEntity<?> checkDriveToken(String token) {
        if (StringUtils.isEmpty((Object)token)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)AppError.of((String)"\u83b7\u53d6DriveToken\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u767b\u9646\u7528\u6237\u662f\u5426\u5bf9\u8bf7\u6c42\u7684\u64cd\u4f5c\u62e5\u6709\u6743\u9650"));
        }
        return ResponseEntity.ok(Collections.singletonMap("driveToken", token));
    }

    @RoleAuthorize
    @PostMapping(value={"/tokens"})
    public ResponseEntity<?> getDriveToken(@Valid @RequestBody DriveAuth body, @RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        String token = this.driveTokenService.getToken(body, userInfo);
        if (body.getItems().size() > 0) {
            DriveAuthItem item = (DriveAuthItem)body.getItems().get(0);
            this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u83b7\u53d6\u8d44\u6e90\u64cd\u4f5c\u6743\u9650\u7684", (Object)item);
        }
        return DriveTokenController.checkDriveToken((String)token);
    }

    @RoleAuthorize
    @GetMapping(value={"/tokens/{actionName}/{bucket}/dirs/{dirId}"})
    public ResponseEntity<?> getAccessDirToken(@PathVariable String bucket, @PathVariable String actionName, @PathVariable String dirId, @RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        bucket = TenantUtil.getBucketNameAuth((String)bucket);
        DriveAuthItem driveAuthItem = new DriveAuthItem(bucket, ActionEnum.valueOf((String)StringUtil.upperCase((String)actionName)), FileTypeEnum.Directory, IdUtil.getDirectoryId((String)dirId));
        DriveAuth driveAuth = new DriveAuth();
        driveAuth.getItems().add(driveAuthItem);
        String token = this.driveTokenService.getToken(driveAuth, userInfo);
        this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u83b7\u53d6\u76ee\u5f55\u64cd\u4f5c\u6743\u9650\u7684", (Object)driveAuth);
        return DriveTokenController.checkDriveToken((String)token);
    }

    @RoleAuthorize
    @GetMapping(value={"/tokens/{actionName}/{bucket}/files/{fileId}"})
    public ResponseEntity<?> getAccessFileToken(@PathVariable String bucket, @PathVariable String actionName, @PathVariable String fileId, @RequestAttribute(value="digi-middleware-auth-user-data") JwtUser userInfo) {
        bucket = TenantUtil.getBucketNameAuth((String)bucket);
        DriveAuth driveAuth = new DriveAuth();
        DriveAuthItem driveAuthItem = new DriveAuthItem(bucket, ActionEnum.valueOf((String)StringUtil.upperCase((String)actionName)), FileTypeEnum.File, fileId);
        driveAuth.getItems().add(driveAuthItem);
        String token = this.driveTokenService.getToken(driveAuth, userInfo);
        this.opLogRepository.saveLog(LogType.EVENT_TRACKING, "\u83b7\u53d6\u6587\u4ef6\u64cd\u4f5c\u6743\u9650\u7684", (Object)driveAuth);
        return DriveTokenController.checkDriveToken((String)token);
    }
}

