/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.FullTextCondition;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.QueryResult;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.SimpleCondition;
import com.digiwin.dap.middleware.dmc.obsolete.service.FileInfoTextService;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileInfoTextController {
    @Autowired
    private FileInfoTextService fileInfoTextService;

    private int replacePageNum(String pageNum) {
        if (StringUtils.isEmpty((Object)pageNum)) {
            return 1;
        }
        return Integer.parseInt(pageNum);
    }

    private int replacePageSize(String pageSize) {
        if (StringUtils.isEmpty((Object)pageSize)) {
            return 10;
        }
        return Integer.parseInt(pageSize);
    }

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/query", "/myresources/query"})
    public ResponseEntity<?> queryFileInfoByCondition(@PathVariable(required=false) String bucket, @RequestBody SimpleCondition query) {
        QueryResult fileInfoPage = this.fileInfoTextService.getFileInfoByFileInfoQuery(bucket, query);
        return ResponseEntity.ok((Object)fileInfoPage);
    }

    @RoleAuthorize
    @GetMapping(value={"/buckets/{bucket}/query/fields/{field}/values/{value}/{pageNum}/{pageSize}", "/buckets/{bucket}/query/fields/{field}/values/{value}/", "/myresources/query/fields/{field}/values/{value}/{pageNum}/{pageSize}", "/myresources/query/fields/{field}/values/{value}/"})
    public ResponseEntity<?> queryFileInfoByField(@PathVariable(required=false) String bucket, @PathVariable String field, @PathVariable String value, @PathVariable(required=false, value="pageNum") String pageNum, @PathVariable(required=false, value="pageSize") String pageSize) {
        int number = this.replacePageNum(pageNum);
        int size = this.replacePageSize(pageSize);
        SimpleCondition query = new SimpleCondition();
        query.setPageNum(number);
        query.setPageSize(size);
        Document queryCondition = this.fileInfoTextService.createQueryCondition(field, value, null);
        query.setCondition(queryCondition);
        QueryResult fileInfoPage = this.fileInfoTextService.getFileInfoByFileInfoQuery(bucket, query);
        return ResponseEntity.ok((Object)fileInfoPage);
    }

    @RoleAuthorize
    @GetMapping(value={"/buckets/{bucket}/query/fields/{field}/operators/{operator}/values/{value}/{pageNum}/{pageSize}", "/buckets/{bucket}/query/fields/{field}/operators/{operator}/values/{value}/", "/myresources/query/fields/{field}/operators/{operator}/values/{value}/{pageNum}/{pageSize}", "/myresources/query/fields/{field}/operators/{operator}/values/{value}/"})
    public ResponseEntity<?> queryFileInfoByOperator(@PathVariable(required=false) String bucket, @PathVariable String field, @PathVariable String operator, @PathVariable String value, @PathVariable(required=false, value="pageNum") String pageNum, @PathVariable(required=false, value="pageSize") String pageSize) {
        int number = this.replacePageNum(pageNum);
        int size = this.replacePageSize(pageSize);
        SimpleCondition query = new SimpleCondition();
        Document queryCondition = this.fileInfoTextService.createQueryCondition(field, value, operator);
        query.setPageNum(number);
        query.setPageSize(size);
        query.setCondition(queryCondition);
        QueryResult fileInfoPage = this.fileInfoTextService.getFileInfoByFileInfoQuery(bucket, query);
        return ResponseEntity.ok((Object)fileInfoPage);
    }

    @PostMapping(value={"/query/fulltext"})
    public ResponseEntity<?> queryFileInfoByFullText(@RequestBody FullTextCondition condition) {
        QueryResult queryResult = this.fileInfoTextService.getFileInfo(condition);
        return ResponseEntity.ok((Object)queryResult);
    }

    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/query/fulltext", "/myresources/query/fulltext"})
    public ResponseEntity<?> queryFileInfoByFullText(@PathVariable(required=false) String bucket, @RequestBody FullTextCondition condition) {
        QueryResult queryResult = this.fileInfoTextService.getFileInfo(bucket, condition);
        return ResponseEntity.ok((Object)queryResult);
    }

    @GetMapping(value={"/query/fulltext/type"})
    public ResponseEntity<?> getFileTypes() {
        HashMap<String, String> map = null;
        ArrayList types = new ArrayList();
        for (FileTypeEnum type : FileTypeEnum.values()) {
            map = new HashMap<String, String>();
            map.put("type", type.getKey());
            map.put("typeName", type.getValue());
            types.add(map);
        }
        return ResponseEntity.ok(types);
    }

    @GetMapping(value={"/query/fulltext/type/{type}"})
    public ResponseEntity<?> getFileSuffixes(@PathVariable String type) {
        return ResponseEntity.ok((Object)FileUtil.getSuffixesByType((FileTypeEnum)FileTypeEnum.valueOf((String)type.toUpperCase())));
    }
}

