/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.obsolete.service.FileTagService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.ActionEnum;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class FileTagController {
    @Autowired
    private FileTagService fileTagService;

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/tags/{tag}", "/myresources/files/{fileId}/tags/{tag}"})
    public ResponseEntity<?> addTag(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String tag) {
        this.fileTagService.addTag(bucket, fileId, tag);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @DeleteMapping(value={"/buckets/{bucket}/files/{fileId}/tags/{tag}", "/myresources/files/{fileId}/tags/{tag}"})
    public ResponseEntity<?> deleteOneTag(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String tag) {
        this.fileTagService.deleteTag(bucket, fileId, tag);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @DeleteMapping(value={"/buckets/{bucket}/files/{fileId}/tags", "/myresources/files/{fileId}/tags"})
    public ResponseEntity<?> deleteTag(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        this.fileTagService.deleteTag(bucket, fileId);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(action=ActionEnum.Write, order=1, fileIndexes={1})
    @PostMapping(value={"/buckets/{bucket}/files/{fileId}/tags/{tag}/replace", "/myresources/files/{fileId}/tags/{tag}/replace"})
    public ResponseEntity<?> replaceTag(@PathVariable(required=false) String bucket, @PathVariable String fileId, @PathVariable String tag) {
        this.fileTagService.replaceTag(bucket, fileId, tag);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @RoleAuthorize(action=ActionEnum.Read, order=1, fileIndexes={1})
    @GetMapping(value={"/buckets/{bucket}/files/{fileId}/tags", "/myresources/files/{fileId}/tags"})
    public ResponseEntity<?> getTags(@PathVariable(required=false) String bucket, @PathVariable String fileId) {
        String tags = this.fileTagService.getTag(bucket, fileId);
        return ResponseEntity.ok(Collections.singletonMap("tags", tags));
    }
}

