/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.ImageInfo;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.domain.ImageResult;
import com.digiwin.dap.middleware.dmc.obsolete.entity.ImageCacheFile;
import com.digiwin.dap.middleware.dmc.obsolete.service.HandleImageService;
import com.digiwin.dap.middleware.dmc.obsolete.service.ImageCacheFileService;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class ImageFileController {
    private static final int MAX_SCALE = 100;
    private static final int MIN_SCALE = 0;
    @Autowired
    private FileDownloadService downloadService;
    @Autowired
    private HandleImageService handleImageService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private ImageCacheFileService imageCacheFileService;

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/scale/{scale}", "/myresources/images/{fileId}/view/0/scale/{scale}"})
    public void dealImagePng(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="scale") int scale, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/scale/" + scale;
        if (scale > 100 || scale <= 0) {
            throw new BusinessException("\u8bbe\u7f6e\u7684\u7f29\u653e\u6bd4\u4f8b\u4e0d\u5408\u9002\uff01");
        }
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setScale(scale);
        imageInfo.setRound(false);
        this.handleImageProportiona(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/scale/{scale}/{cornerRadius}", "/myresources/images/{fileId}/view/0/scale/{scale}/{cornerRadius}"})
    public void dealImageRound(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="scale") int scale, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/scale/" + scale + "/" + cornerRadius;
        if (scale > 100 || scale <= 0) {
            throw new BusinessException("\u8bbe\u7f6e\u7684\u7f29\u653e\u6bd4\u4f8b\u4e0d\u5408\u9002\uff01");
        }
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setScale(scale);
        imageInfo.setCornerRadius(cornerRadius);
        imageInfo.setRound(true);
        this.handleImageProportiona(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/scale/{scale}/format/{format}", "/myresources/images/{fileId}/view/0/scale/{scale}/format/{format}"})
    public void dealImage(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="scale") int scale, @PathVariable(value="format") String format, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/scale/" + scale + "/format/" + format;
        if (scale > 100 || scale <= 0) {
            throw new BusinessException("\u8bbe\u7f6e\u7684\u7f29\u653e\u6bd4\u4f8b\u4e0d\u5408\u9002\uff01");
        }
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setScale(scale);
        imageInfo.setFormat(format);
        imageInfo.setRound(false);
        this.handleImageProportiona(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/w/{width}", "/myresources/images/{fileId}/view/0/w/{width}"})
    public void dealImageSetWidth(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/w/" + width;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setWidth(width);
        imageInfo.setHeight(0);
        imageInfo.setRound(false);
        this.handleImage(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/w/{width}/{cornerRadius}", "/myresources/images/{fileId}/view/0/w/{width}/{cornerRadius}"})
    public void dealImageSetWidthRound(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/w/" + width + "/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setWidth(width);
        imageInfo.setHeight(0);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImage(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/w/{width}/format/{format}", "/myresources/images/{fileId}/view/0/w/{width}/format/{format}"})
    public void dealImageSetWidthFormat(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, @PathVariable(value="format") String format, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/w/" + width + "/format/" + format;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setWidth(width);
        imageInfo.setHeight(0);
        imageInfo.setFormat(format);
        imageInfo.setRound(false);
        this.handleImage(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/h/{height}", "/myresources/images/{fileId}/view/0/h/{height}"})
    public void dealImageSetHeight(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="height") int height, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/h/" + height;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(0);
        imageInfo.setRound(false);
        this.handleImage(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/h/{height}/{cornerRadius}", "/myresources/images/{fileId}/view/0/h/{height}/{cornerRadius}"})
    public void dealImageSetHeightRound(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="height") int height, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/h/" + height + "/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(0);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImage(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/0/h/{height}/format/{format}", "/myresources/images/{fileId}/view/0/h/{height}/format/{format}"})
    public void dealImageSetHeightFormat(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="height") int height, @PathVariable(value="format") String format, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "0/h/" + height + "/format/" + format;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(0);
        imageInfo.setFormat(format);
        imageInfo.setRound(false);
        this.handleImage(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/w/{width}/h/{height}", "/myresources/images/{fileId}/view/1/w/{width}/h/{height}"})
    public void dealImageClipPng(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, @PathVariable(value="height") int height, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/w/" + width + "/h/" + height;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(width);
        imageInfo.setRound(false);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/w/{width}/h/{height}/{cornerRadius}", "/myresources/images/{fileId}/view/1/w/{width}/h/{height}/{cornerRadius}"})
    public void dealImageClipRound(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, @PathVariable(value="height") int height, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/w/" + width + "/h/" + height + "/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(width);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/w/{width}/h/{height}/format/{format}", "/myresources/images/{fileId}/view/1/w/{width}/h/{height}/format/{format}"})
    public void dealImageClipFormat(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, @PathVariable(value="height") int height, @PathVariable(value="format") String format, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/w/" + width + "/h/" + height + "/" + format;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(width);
        imageInfo.setFormat(format);
        imageInfo.setRound(false);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/w/{width}", "/myresources/images/{fileId}/view/1/w/{width}"})
    public void dealImageClipSetWidth(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/w/" + width;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(width);
        imageInfo.setWidth(width);
        imageInfo.setRound(false);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/w/{width}/format/{format}", "/myresources/images/{fileId}/view/1/w/{width}/format/{format}"})
    public void dealImageClipSetWidthFormat(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="format") String format, @PathVariable(value="width") int width, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/w/" + width + "/format/" + format;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(width);
        imageInfo.setWidth(width);
        imageInfo.setRound(false);
        imageInfo.setFormat(format);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/w/{width}/{cornerRadius}", "/myresources/images/{fileId}/view/1/w/{width}/{cornerRadius}"})
    public void dealImageClipSetWidthRound(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="width") int width, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/w/" + width + "/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(width);
        imageInfo.setWidth(width);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/h/{height}", "/myresources/images/{fileId}/view/1/h/{height}"})
    public void dealImageClipSetHeight(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="height") int height, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/h/" + height;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(height);
        imageInfo.setRound(false);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/h/{height}/format/{format}", "/myresources/images/{fileId}/view/1/h/{height}/format/{format}"})
    public void dealImageClipSetHeightFormat(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="format") String format, @PathVariable(value="height") int height, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/h/" + height + "/format/" + format;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(height);
        imageInfo.setRound(false);
        imageInfo.setFormat(format);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/1/h/{height}/{cornerRadius}", "/myresources/images/{fileId}/view/1/h/{height}/{cornerRadius}"})
    public void dealImageClipSetHeightRound(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="height") int height, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "1/h/" + height + "/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(height);
        imageInfo.setWidth(height);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/larger/{cornerRadius}", "/myresources/images/{fileId}/view/larger/{cornerRadius}"})
    public void dealImageLarger(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "larger/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(256);
        imageInfo.setWidth(256);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/large/{cornerRadius}", "/myresources/images/{fileId}/view/large/{cornerRadius}"})
    public void dealImageLarge(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "large/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(64);
        imageInfo.setWidth(64);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/middle/{cornerRadius}", "/myresources/images/{fileId}/view/middle/{cornerRadius}"})
    public void dealImageMiddle(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "middle/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(32);
        imageInfo.setWidth(32);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/small/{cornerRadius}", "/myresources/images/{fileId}/view/small/{cornerRadius}"})
    public void dealImageSmall(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "small/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(20);
        imageInfo.setWidth(20);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/smaller/{cornerRadius}", "/myresources/images/{fileId}/view/smaller/{cornerRadius}"})
    public void dealImageSmaller(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, @PathVariable(value="cornerRadius") int cornerRadius, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "smaller/" + cornerRadius;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(16);
        imageInfo.setWidth(16);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(cornerRadius);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/forAndroid", "/myresources/images/{fileId}/view/forAndroid"})
    public void dealImageForAndroid(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "forAndroid";
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(48);
        imageInfo.setWidth(48);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(11);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/forPad", "/myresources/images/{fileId}/view/forPad"})
    public void dealImageForPad(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "forPad";
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(80);
        imageInfo.setWidth(80);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(18);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize(order=1)
    @GetMapping(value={"/buckets/{bucket}/images/{fileId}/view/forIos", "/myresources/images/{fileId}/view/forIos"})
    public void dealImageForIos(@PathVariable(required=false, value="bucket") String bucket, @PathVariable(value="fileId") String fileId, HttpServletResponse res) {
        bucket = TenantUtil.getBucketName((String)bucket);
        String condition = "forIos";
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setHeight(58);
        imageInfo.setWidth(58);
        imageInfo.setRound(true);
        imageInfo.setCornerRadius(14);
        this.handleImageClip(bucket, fileId, imageInfo, res, condition);
    }

    @RoleAuthorize
    @GetMapping(value={"/buckets/{bucket}/imageCacheFiles", "/myresources/imageCacheFiles"})
    public ResponseEntity<?> findImageCacheFiles(@PathVariable(required=false, value="bucket") String bucket) {
        bucket = TenantUtil.getBucketName((String)bucket);
        return ResponseEntity.ok((Object)this.imageCacheFileService.imageCacheFiles(bucket));
    }

    @RoleAuthorize
    @DeleteMapping(value={"/buckets/{bucket}/imageCacheFilesClean", "/myresources/imageCacheFilesClean"})
    public void clean(@PathVariable(required=false, value="bucket") String bucket) {
        bucket = TenantUtil.getBucketName((String)bucket);
        this.imageCacheFileService.clean(bucket);
    }

    private void handleImageProportiona(String bucket, String fileId, ImageInfo imageInfo, HttpServletResponse res, String condition) {
        String name;
        byte[] newImageByte;
        ImageCacheFile cacheFile = this.imageCacheFileService.findCacheFile(fileId, condition, bucket);
        if (cacheFile == null) {
            ImageResult imageResult = this.handleImageService.getProportionallyProcessedImage(bucket, fileId, imageInfo, condition);
            newImageByte = imageResult.getImageBytes();
            name = imageResult.getFileName();
        } else {
            FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
            name = fileInfo.getFileName();
            FileInfo dualFileInfo = FileInfo.dual((String)name, (String)cacheFile.getNewImageId());
            newImageByte = this.downloadService.downloadToBytes(bucket, dualFileInfo);
        }
        this.setHeader(res, name, newImageByte);
    }

    private void handleImage(String bucket, String fileId, ImageInfo imageInfo, HttpServletResponse res, String condition) {
        String name;
        byte[] newImageByte;
        ImageCacheFile cacheFile = this.imageCacheFileService.findCacheFile(fileId, condition, bucket);
        if (cacheFile == null) {
            ImageResult imageResult = this.handleImageService.getProcessedImage(bucket, fileId, imageInfo, condition);
            newImageByte = imageResult.getImageBytes();
            name = imageResult.getFileName();
        } else {
            FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
            name = fileInfo.getFileName();
            FileInfo dualFileInfo = FileInfo.dual((String)name, (String)cacheFile.getNewImageId());
            newImageByte = this.downloadService.downloadToBytes(bucket, dualFileInfo);
        }
        this.setHeader(res, name, newImageByte);
    }

    private void handleImageClip(String bucket, String fileId, ImageInfo imageInfo, HttpServletResponse res, String condition) {
        String name;
        byte[] newImageByte;
        ImageCacheFile cacheFile = this.imageCacheFileService.findCacheFile(fileId, condition, bucket);
        if (cacheFile == null) {
            ImageResult imageResult = this.handleImageService.getProcessedImageClip(bucket, fileId, imageInfo, condition);
            newImageByte = imageResult.getImageBytes();
            name = imageResult.getFileName();
        } else {
            FileInfo fileInfo = this.fileNodeService.findOne(bucket, fileId);
            name = fileInfo.getFileName();
            FileInfo dualFileInfo = FileInfo.dual((String)name, (String)cacheFile.getNewImageId());
            newImageByte = this.downloadService.downloadToBytes(bucket, dualFileInfo);
        }
        this.setHeader(res, name, newImageByte);
    }

    private void setHeader(HttpServletResponse res, String name, byte[] newImageByte) {
        try {
            res.addHeader("Content-Disposition", "inline;filename=" + new String(name.getBytes(), "utf-8"));
            res.setContentType(Files.probeContentType(Paths.get(name, new String[0])));
            res.setHeader("ContentLength", String.valueOf(newImageByte.length));
            res.getOutputStream().write(newImageByte);
            res.getOutputStream().flush();
            res.getOutputStream().close();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }
}

