/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.domain.v2.PageData;
import com.digiwin.dap.middleware.dmc.obsolete.api.OperationLogController;
import com.digiwin.dap.middleware.dmc.obsolete.domain.log.ChangeQuery;
import com.digiwin.dap.middleware.dmc.obsolete.domain.log.LogFieldPath;
import com.digiwin.dap.middleware.dmc.obsolete.domain.log.ModifiedInfo;
import com.digiwin.dap.middleware.dmc.obsolete.entity.CompareInfo;
import com.digiwin.dap.middleware.dmc.obsolete.service.OperationLogService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class OperationLogController {
    @Autowired
    private OperationLogService operationLogService;

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/buckets/{bucket}/changelogs"}, method={RequestMethod.POST})
    public ResponseEntity<?> dataComparison(@PathVariable(required=false) String bucket, @Validated @RequestBody ModifiedInfo modifiedInfo) {
        CompareInfo compareInfo = modifiedInfo.generateCompareInfo();
        LogFieldPath logFieldPath = new LogFieldPath();
        List changeInfoS = this.operationLogService.getModifyContent(modifiedInfo.getOriginJson(), modifiedInfo.getModifyJson(), modifiedInfo.getLogFieldList(), modifiedInfo.getPrimaryKeyList(), logFieldPath);
        if (changeInfoS.size() == 0) {
            return ResponseEntity.ok((Object)HttpStatus.OK);
        }
        compareInfo.setChangeInfoList(changeInfoS);
        this.operationLogService.insert(bucket, compareInfo, ".".concat(compareInfo.getSource()));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/buckets/{bucket}/changelogs/result"}, method={RequestMethod.POST})
    public ResponseEntity<?> saveChangeLogs(@PathVariable(required=false) String bucket, @Validated @RequestBody CompareInfo compareInfo) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = LocalDateTime.now().atZone(ZoneId.of("Asia/Shanghai"));
        compareInfo.setEditTime(format.format(Date.from(zonedDateTime.toInstant()).getTime()));
        this.operationLogService.insert(bucket, compareInfo, ".".concat(compareInfo.getSource()));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/buckets/{bucket}/source/{source}/primaryKey/{primaryKey}/changelogs/count/{count}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getChangeLogs(@PathVariable(required=false) String bucket, @PathVariable String source, @PathVariable String primaryKey, @PathVariable int count, @RequestParam(name="params", required=false) String params) {
        ChangeQuery changeQuery = ChangeQuery.getSelf((String)params);
        List changeInfoS = this.operationLogService.getCompareInfoList(bucket, source, primaryKey, count, changeQuery);
        return ResponseEntity.ok((Object)changeInfoS);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/buckets/{bucket}/source/{source}/tenant/{tenantId}/changelogs/count/{count}"}, method={RequestMethod.POST})
    public ResponseEntity<?> getChangeLogsByTenantId(@PathVariable(required=false) String bucket, @PathVariable String source, @PathVariable String tenantId, @PathVariable int count, @RequestBody ChangeQuery changeQuery) {
        List changeInfoS = this.operationLogService.getCompareInfoListByTenant(bucket, source, tenantId, count, changeQuery);
        return ResponseEntity.ok((Object)changeInfoS);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/buckets/{bucket}/source/{source}/changelogs/multitenant"}, method={RequestMethod.POST})
    public ResponseEntity<?> getChangeLogsForMultiTenant(@PathVariable(required=false) String bucket, @PathVariable String source, @RequestBody ChangeQuery changeQuery) {
        Map changeInfoS = this.operationLogService.getChangeLogsForMultiTenant(bucket, source, changeQuery);
        return ResponseEntity.ok((Object)changeInfoS);
    }

    @PostMapping(value={"/buckets/{bucket}/source/{source}/changelogs"})
    public ResponseEntity<PageData<CompareInfoVO>> getChangeLogs(@PathVariable(required=false) String bucket, @PathVariable String source, @RequestBody ChangeQuery changeQuery) {
        PageData pageData = this.operationLogService.getCompareInfoPage(bucket, source, changeQuery);
        ArrayList<CompareInfoVO> voList = new ArrayList<CompareInfoVO>();
        BeanCopier beanCopier = BeanCopier.create(CompareInfo.class, CompareInfoVO.class, (boolean)false);
        for (CompareInfo old : pageData.getList()) {
            CompareInfoVO vo = new CompareInfoVO(this);
            beanCopier.copy((Object)old, (Object)vo, null);
            voList.add(vo);
        }
        return ResponseEntity.ok((Object)PageData.data((long)pageData.getTotal(), voList));
    }
}

