/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.dao.ShareCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.domain.EnvProperties;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.enumeration.InlineAttachment;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.SharedFile;
import com.digiwin.dap.middleware.dmc.obsolete.domain.ShareFileTarget;
import com.digiwin.dap.middleware.dmc.obsolete.service.ShareFileService;
import com.digiwin.dap.middleware.dmc.service.business.FidCheckService;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileInfoStatService;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RoleAuthorize
@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class ShareFileController {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private FidCheckService fidCheckService;
    @Autowired
    private ShareCrudService shareCrudService;
    @Autowired
    private ShareFileService shareFileService;
    @Autowired
    private FileDownloadService fileDownloadService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private FileInfoStatService fileInfoStatService;

    @PostMapping(value={"/myresources/ShareFiles/toTarget"})
    public ResponseEntity<?> shareFilesToTarget(@PathVariable(required=false) String bucket, @RequestBody ShareFileTarget body, HttpServletRequest request) {
        bucket = TenantUtil.getBucketName((String)bucket);
        this.fidCheckService.canOperateFileId(bucket, body.getFileIds());
        ArrayList<String> sharedUrls = new ArrayList<String>();
        for (String fileId : body.getFileIds()) {
            FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileId);
            if (fileInfo != null) {
                String shareId = this.shareFileService.shareFileForever(bucket, fileInfo, body);
                String url = this.getUrl(request, bucket, shareId, UserUtils.getUserId(), UserUtil.getTenant()) + "/toTarget";
                this.shareFileService.updateUrl(bucket, shareId, url);
                sharedUrls.add(url);
                continue;
            }
            throw new BusinessException("\u8be5\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u5206\u4eab\uff01");
        }
        return ResponseEntity.ok(sharedUrls);
    }

    @PostMapping(value={"/myresources/ShareFiles/d/{d}/toTarget"})
    public ResponseEntity<?> shareFilesToTarget(@PathVariable(required=false) String bucket, @RequestBody ShareFileTarget body, @PathVariable(value="d") int d, HttpServletRequest request) {
        bucket = TenantUtil.getBucketName((String)bucket);
        this.fidCheckService.canOperateFileId(bucket, body.getFileIds());
        ArrayList<String> sharedUrls = new ArrayList<String>();
        for (String fileId : body.getFileIds()) {
            FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(bucket, fileId);
            if (fileInfo != null) {
                String shareId = this.shareFileService.shareFileTimeLimit(bucket, fileInfo, d, body);
                String url = this.getUrl(request, bucket, shareId, UserUtils.getUserId(), UserUtil.getTenant()) + "/toTarget";
                this.shareFileService.updateUrl(bucket, shareId, url);
                sharedUrls.add(url);
                continue;
            }
            throw new BusinessException("\u8be5\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u5206\u4eab\uff01");
        }
        return ResponseEntity.ok(sharedUrls);
    }

    @GetMapping(value={"/myresources/{name}/shareFiles/files/{shareId}/toTarget", "/myresources/{tenantId}/{name}/shareFiles/files/{shareId}/toTarget"})
    public void previewFile(@PathVariable(required=false) String name, @PathVariable String shareId, HttpServletRequest request, HttpServletResponse response) {
        String bucketName = TenantUtil.getBucketName();
        SharedFile sharedFile = this.shareCrudService.getSharedFile(bucketName, shareId);
        this.fileDownloadService.downloadFile(bucketName, sharedFile.getFileId(), InlineAttachment.inline, request, response);
    }

    @GetMapping(value={"/myresources/findShareFiles/giveMy"})
    public ResponseEntity<?> getShareFilesGiveMy(@PathVariable(required=false) String bucket) {
        bucket = TenantUtil.getBucketName((String)bucket);
        List sharedFiles = this.shareCrudService.findAll(bucket);
        List sharedFileList = new ArrayList();
        if (sharedFiles != null && !sharedFiles.isEmpty()) {
            sharedFileList = this.shareFileService.getSharedFilesGiveMy(sharedFiles, UserUtil.getJwtUser());
            Collections.reverse(sharedFileList);
        }
        return ResponseEntity.ok(sharedFileList);
    }

    @GetMapping(value={"/users/{userId}/files/{fileId}"})
    public ResponseEntity<?> getShareFilesForFileInfo(@PathVariable String userId, @PathVariable String fileId, @PathVariable(required=false) String bucket) {
        bucket = TenantUtil.getBucketName((String)bucket);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        JwtUser jwtUser = (JwtUser)authentication.getPrincipal();
        List sharedFiles = this.shareCrudService.findAll(bucket);
        List sharedFileList = new ArrayList();
        if (sharedFiles != null && !sharedFiles.isEmpty()) {
            sharedFileList = this.shareFileService.getSharedFilesGiveMy(sharedFiles, jwtUser);
        }
        if (sharedFileList != null && !sharedFileList.isEmpty()) {
            for (SharedFile sharedFile : sharedFileList) {
                if (sharedFile.getUserId().contains(userId)) continue;
                throw new BusinessException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6587\u4ef6");
            }
        }
        FileInfo fileInfo = this.fileInfoStatService.getFileInfoByUser(bucket, fileId, userId);
        return ResponseEntity.ok((Object)fileInfo);
    }

    private String getUrl(HttpServletRequest request, String bucketName, String shareFileId, String userName, String tenantId) {
        String url;
        String contextPath = request.getRequestURI();
        if (bucketName.equals(TenantUtil.getBucketName())) {
            String prefix = contextPath.substring(0, contextPath.indexOf("/myresources"));
            url = tenantId == null || "default".equals(tenantId) ? request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + prefix + "/myresources/" + userName + "/shareFiles/files/" + shareFileId : request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + prefix + "/myresources/" + tenantId + "/" + userName + "/shareFiles/files/" + shareFileId;
        } else {
            String prefix = contextPath.substring(0, contextPath.indexOf("/buckets"));
            url = StringUtils.hasLength((String)this.envProperties.getDmcUri()) ? this.envProperties.getDmcUri() + prefix + "/buckets/" + bucketName + "/shareFiles/files/" + shareFileId : request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + prefix + "/buckets/" + bucketName + "/shareFiles/files/" + shareFileId;
        }
        return url;
    }
}

