/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.obsolete.entity.Text;
import com.digiwin.dap.middleware.dmc.obsolete.service.TextService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class TextController {
    @Autowired
    private TextService textService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/buckets/{bucket}/text"})
    public ResponseEntity<?> saveTextInfo(@PathVariable(required=false) String bucket, @Validated @RequestBody Text text) {
        Assert.hasText((String)text.getSource(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        text.setCreateDate(new Date());
        String id = this.textService.insert(bucket, text);
        return ResponseEntity.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    @GetMapping(value={"/buckets/{bucket}/text/{id}"})
    public ResponseEntity<?> getTextInfo(@PathVariable(required=false) String bucket, @PathVariable String id) {
        return ResponseEntity.ok((Object)this.textService.findById(bucket, id));
    }

    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/buckets/{bucket}/text"})
    public ResponseEntity<?> updateTextInfo(@PathVariable(required=false) String bucket, @RequestBody Text text) {
        this.textService.update(bucket, text);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/buckets/{bucket}/text/{id}"})
    public ResponseEntity<?> deleteTextInfo(@PathVariable(required=false) String bucket, @PathVariable String id) {
        this.textService.deleteById(bucket, id);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

