/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.api;

import com.digiwin.dap.middleware.dmc.constant.BaseField;
import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.domain.annotation.RoleAuthorize;
import com.digiwin.dap.middleware.dmc.domain.annotation.UploadMark;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.service.business.impl.FileUploadServiceDecryptedDecorator;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.domain.StdData;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/dmc/v1"})
public class UploadFileController {
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private DirectoryNodeService directoryNodeService;
    @Autowired
    private DirectoryCrudService directoryCrudService;
    @Autowired
    private BucketRepository bucketRepository;

    @UploadMark
    @RoleAuthorize
    @PostMapping(value={"/buckets/{bucket}/batchfiles"})
    public ResponseEntity<?> batchUploadV1(@PathVariable(required=false, value="bucket") String bucket, @RequestPart(value="file") MultipartFile[] files, @RequestParam(required=false, name="path") String path, @RequestHeader(required=false, name="digi-middleware-security", defaultValue="false") String dmcSecurity, @RequestHeader(required=false, name="digi-middleware-digital-envelope") String digitalEnvelope) {
        bucket = TenantUtil.getBucketName((String)bucket);
        StringBuilder stringBuilder = new StringBuilder();
        String dirId = this.getDirId(BaseField.EMPTY_UUID, path, bucket);
        ArrayList fileInfos = new ArrayList();
        for (MultipartFile file : files) {
            HashMap<String, String> fileMap = new HashMap<String, String>();
            FileInfo fileInfo = new FileInfo();
            String fileName = file.getOriginalFilename();
            if (!StringUtils.hasLength((String)fileName)) continue;
            try {
                fileInfo.setExtension(FileUtil.getExtension((String)fileName));
                fileInfo.setDisplayName(fileName);
                fileInfo.setFileName(fileName);
                fileInfo.setDirectoryId(dirId);
                byte[] bytes = file.getBytes();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                FileUploadServiceDecryptedDecorator fileUploadServiceDecryptedDecorator = new FileUploadServiceDecryptedDecorator(this.fileUploadService, this.bucketRepository, Boolean.valueOf(dmcSecurity).booleanValue(), digitalEnvelope);
                String fileId = fileUploadServiceDecryptedDecorator.uploadFromStream(bucket, fileInfo, (InputStream)inputStream).getId().toString();
                fileMap.put("name", fileInfo.getFileName());
                fileMap.put("id", fileId);
                fileInfos.add(fileMap);
            }
            catch (Exception e) {
                stringBuilder.append(String.format("\u6587\u4ef6[%s]\u4e0a\u4f20\u5931\u8d25,", fileName));
            }
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return ResponseEntity.ok((Object)StdData.ok(fileInfos));
    }

    private String getDirId(UUID dirId, String path, String bucketName) {
        String firstDirName;
        if (ObjectUtils.isEmpty((Object)path)) {
            return dirId.toString();
        }
        List dirInfos = this.directoryNodeService.findByParentId(bucketName, dirId);
        if (path.contains(File.separator)) {
            firstDirName = path.substring(0, path.indexOf(File.separator));
        } else {
            firstDirName = path;
            path = "";
        }
        for (DirInfo dirInfo : dirInfos) {
            if (!dirInfo.getName().equals(firstDirName)) continue;
            return this.getDirId(dirInfo.getId(), path.substring(path.indexOf(File.separator) + 1), bucketName);
        }
        DirInfo dirInfoParam = new DirInfo();
        dirInfoParam.setParentId(dirId);
        dirInfoParam.setName(firstDirName);
        dirInfoParam.setDisplayName(firstDirName);
        dirInfoParam.setBucket(bucketName);
        String newDirId = this.directoryCrudService.insert((UuIdEntity)dirInfoParam);
        return this.getDirId(IdUtil.uuid((String)newDirId), path.substring(path.indexOf(File.separator) + 1), bucketName);
    }
}

