/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service;

import com.digiwin.dap.middleware.dmc.dao.DirectoryCrudService;
import com.digiwin.dap.middleware.dmc.dao.FileInfoCrudService;
import com.digiwin.dap.middleware.dmc.dao.RecycleCrudService;
import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.domain.DirTree;
import com.digiwin.dap.middleware.dmc.domain.enumeration.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.DirInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.entity.uuid.RecycleBin;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecycleBinV1Service {
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private RecycleCrudService recycleCrudService;
    @Autowired
    private FileInfoCrudService fileInfoCrudService;
    @Autowired
    private DirectoryCrudService directoryCrudService;
    @Autowired
    private DirectoryNodeService directoryNodeService;

    public void restoreRecycleBinV1(String bucket, RecycleBin recycleBin) {
        if (FileTypeEnum.File.toString().equals(recycleBin.getContentType())) {
            FileInfo fileInfo = recycleBin.getFileInfo();
            this.recoverDirectory(bucket, recycleBin.getPath());
            fileInfo.setDeletion(Long.valueOf(0L));
            this.fileInfoCrudService.insert((UuIdEntity)fileInfo);
        }
        if (FileTypeEnum.Directory.toString().equals(recycleBin.getContentType())) {
            DirTree dirTree = recycleBin.getDeletedDirInfo();
            this.recoverDirectory(bucket, recycleBin.getPath());
            DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, dirTree.getId());
            this.createDirectory(bucket, dirInfo, dirTree);
            this.recoverRecycleBin(bucket, dirTree);
        }
        this.recycleCrudService.deleteById(bucket, recycleBin.getId());
    }

    private void createDirectory(String bucket, DirInfo dirInfo, DirTree dirTree) {
        if (dirInfo == null) {
            dirInfo = new DirInfo();
            BeanUtils.copyProperties((Object)dirTree, (Object)dirInfo);
            dirInfo.setDeletion(Long.valueOf(0L));
            dirInfo.setBucket(bucket);
            this.directoryCrudService.insert((UuIdEntity)dirInfo);
        }
    }

    private void recoverRecycleBin(String bucket, DirTree dirTree) {
        for (FileInfo fileInfo : dirTree.getFiles()) {
            this.fileInfoCrudService.insert((UuIdEntity)fileInfo);
        }
        for (DirTree tree : dirTree.getDirs()) {
            DirInfo dirInfo = (DirInfo)this.directoryNodeService.findById(bucket, tree.getId());
            this.createDirectory(bucket, dirInfo, tree);
            this.recoverRecycleBin(bucket, tree);
        }
    }

    private void recoverDirectory(String bucket, List<DirInfo> dirInfos) {
        dirInfos.forEach(dir -> {
            DirInfo dirInfo = (DirInfo)this.directoryCrudService.findById(bucket, dir.getId());
            if (dirInfo != null) {
                this.directoryNodeService.decrementToZero(bucket, dirInfo.getId());
            } else {
                dir.setDeletion(Long.valueOf(0L));
                this.directoryCrudService.save((UuIdEntity)dir);
            }
        });
    }

    public void deleteRecycleBinV1(String bucket, RecycleBin recycleBin) {
        if (FileTypeEnum.File.toString().equals(recycleBin.getContentType())) {
            FileInfo fileInfo = recycleBin.getFileInfo();
            this.fileUploadService.deleteFile(bucket, fileInfo);
        }
        if (FileTypeEnum.Directory.toString().equals(recycleBin.getContentType())) {
            DirTree dirTree = recycleBin.getDeletedDirInfo();
            this.deleteDirectory(bucket, dirTree);
        }
        this.recycleCrudService.deleteById(bucket, recycleBin.getId());
    }

    private void deleteDirectory(String bucket, DirTree dirTree) {
        for (FileInfo fileInfo : dirTree.getFiles()) {
            this.fileUploadService.deleteFile(bucket, fileInfo);
        }
        for (DirTree dir : dirTree.getDirs()) {
            this.deleteDirectory(bucket, dir);
        }
    }
}

