/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.base;

import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.obsolete.service.base.DocumentService;
import com.digiwin.dap.middleware.dmc.storage.MongoConfigFactory;
import com.digiwin.dap.middleware.dmc.storage.gridfs.MongoConfiguration;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractDocumentService<T extends UuIdEntity>
implements DocumentService<T> {
    private final Map<String, MongoCollection<T>> mongoCollections = new ConcurrentHashMap();
    private MongoCollection<T> mongoCollection;
    @Autowired
    private MongoConfigFactory mongoDbFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoCollection<T> getDocuments(String bucket, String collectionName) {
        if (!this.mongoCollections.containsKey(collectionName)) {
            AbstractDocumentService abstractDocumentService = this;
            synchronized (abstractDocumentService) {
                if (!this.mongoCollections.containsKey(collectionName)) {
                    MongoConfiguration mongoConfiguration = this.mongoDbFactory.getConfiguration(bucket);
                    if (".fileInfos".equals(this.getCollectionName())) {
                        Document document = new Document("fullText", (Object)"text");
                        this.mongoCollection = mongoConfiguration.getMongoDatabase().getCollection(collectionName, this.getEntityClass());
                        this.mongoCollection.createIndex((Bson)document);
                    } else {
                        this.mongoCollection = mongoConfiguration.getMongoDatabase().getCollection(collectionName, this.getEntityClass());
                    }
                    this.mongoCollections.put(collectionName, this.mongoCollection);
                }
            }
        }
        if (!this.mongoCollections.containsKey(collectionName)) {
            return null;
        }
        return (MongoCollection)this.mongoCollections.get(collectionName);
    }

    public MongoCollection<T> getLoginUserDocuments(String bucket) {
        String collectionName;
        if (!bucket.equals(TenantUtil.getBucketName())) {
            collectionName = bucket + this.getCollectionName();
        } else {
            JwtUser jwtUser = UserUtil.getJwtUser();
            collectionName = (jwtUser.getIam() == false ? bucket : jwtUser.getUserId()) + this.getCollectionName();
        }
        return this.getDocuments(bucket, collectionName);
    }

    public MongoCollection<T> getLoginUserDocuments(String bucket, String tableName) {
        String collectionName;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!bucket.equals(TenantUtil.getBucketName())) {
            collectionName = bucket + tableName;
        } else {
            JwtUser jwtUser = (JwtUser)authentication.getPrincipal();
            collectionName = (jwtUser.getIam() == false ? bucket : jwtUser.getUserId()) + tableName;
        }
        return this.getDocuments(bucket, collectionName);
    }

    protected abstract String getCollectionName();

    protected abstract Class<T> getEntityClass();

    public String insert(String bucket, T data) {
        if (data.getId() == null) {
            data.setId(UUID.randomUUID());
        }
        UserUtil.setCreateFields(data);
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        mongoCollection.insertOne(data);
        return data.getId().toString();
    }

    public String insert(String bucket, T data, String collectionName) {
        if (data.getId() == null) {
            data.setId(UUID.randomUUID());
        }
        UserUtil.setCreateFields(data);
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket, collectionName);
        mongoCollection.insertOne(data);
        return data.getId().toString();
    }

    public T findById(String bucket, String id) {
        return (T)this.findById(bucket, IdUtil.uuid((String)id));
    }

    public T findById(String bucket, UUID id) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        return (T)((UuIdEntity)mongoCollection.find(Filters.eq((String)"_id", (Object)id)).first());
    }

    public void deleteById(String bucket, String objectId) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        BasicDBObject query = new BasicDBObject("_id", (Object)IdUtil.uuid((String)objectId));
        mongoCollection.deleteOne((Bson)query);
    }
}

