/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.base;

import com.digiwin.dap.middleware.dmc.obsolete.entity.Text;
import com.digiwin.dap.middleware.dmc.obsolete.service.base.TextDocService;
import com.digiwin.dap.middleware.dmc.storage.MongoConfigFactory;
import com.digiwin.dap.middleware.dmc.storage.gridfs.MongoConfiguration;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.CopyObjectUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public abstract class TextDocumentService<T extends Text>
implements TextDocService<T> {
    private final Map<String, MongoCollection<T>> mongoCollections = new ConcurrentHashMap();
    private MongoCollection<T> mongoCollection;
    @Autowired
    private MongoConfigFactory mongoDbFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoCollection<T> getDocuments(String bucket, String collectionName) {
        if (!this.mongoCollections.containsKey(collectionName)) {
            TextDocumentService textDocumentService = this;
            synchronized (textDocumentService) {
                if (!this.mongoCollections.containsKey(collectionName)) {
                    MongoConfiguration mongoConfiguration = this.mongoDbFactory.getConfiguration(bucket);
                    this.mongoCollection = ".fileInfos".equals(this.getCollectionName()) ? mongoConfiguration.getMongoDatabase().getCollection(collectionName, this.getEntityClass()) : mongoConfiguration.getMongoDatabase().getCollection(collectionName, this.getEntityClass());
                    this.mongoCollections.put(collectionName, this.mongoCollection);
                }
            }
        }
        if (!this.mongoCollections.containsKey(collectionName)) {
            return null;
        }
        return (MongoCollection)this.mongoCollections.get(collectionName);
    }

    public MongoCollection<T> getAnonymousUserDocuments(String bucket, String userName) {
        String collectionName = StringUtils.isEmpty((Object)userName) ? bucket + this.getCollectionName() : userName + this.getCollectionName();
        return this.getDocuments(bucket, collectionName);
    }

    public MongoCollection<T> getLoginUserDocuments(String bucket) {
        String collectionName;
        if (!bucket.equals(TenantUtil.getBucketName())) {
            collectionName = bucket + this.getCollectionName();
        } else {
            JwtUser jwtUser = UserUtil.getJwtUser();
            collectionName = (jwtUser.getIam() == false ? bucket : jwtUser.getUserId()) + this.getCollectionName();
        }
        return this.getDocuments(bucket, collectionName);
    }

    public MongoCollection<T> getLoginUserDocuments(String bucket, String tableName) {
        String collectionName;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!bucket.equals(TenantUtil.getBucketName())) {
            collectionName = bucket + tableName;
        } else {
            JwtUser jwtUser = (JwtUser)authentication.getPrincipal();
            collectionName = (jwtUser.getIam() == false ? bucket : jwtUser.getUserId()) + tableName;
        }
        return this.getDocuments(bucket, collectionName);
    }

    protected abstract String getCollectionName();

    protected abstract Class<T> getEntityClass();

    public String insert(String bucket, T data) {
        if (data.getId() == null) {
            data.setId(UUID.randomUUID());
        }
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        mongoCollection.insertOne(data);
        return data.getId().toString();
    }

    public String insert(String bucket, T data, String collectionName) {
        if (data.getId() == null) {
            data.setId(UUID.randomUUID());
        }
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket, collectionName);
        mongoCollection.insertOne(data);
        return data.getId().toString();
    }

    public T findById(String bucket, String objectId) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        BasicDBObject query = new BasicDBObject("_id", (Object)IdUtil.uuid((String)objectId));
        return (T)((Text)mongoCollection.find((Bson)query).first());
    }

    public void deleteById(String bucket, String objectId) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        BasicDBObject query = new BasicDBObject("_id", (Object)IdUtil.uuid((String)objectId));
        mongoCollection.deleteOne((Bson)query);
    }

    public void update(String bucket, BasicDBObject filter, BsonDocument update) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        mongoCollection.updateOne((Bson)filter, (Bson)update);
    }

    public void update(String bucket, T data) {
        MongoCollection mongoCollection = this.getLoginUserDocuments(bucket);
        Text oldData = this.findById(bucket, data.getId().toString());
        BasicDBObject filter = new BasicDBObject("_id", (Object)IdUtil.uuid((String)data.getId().toString()));
        List mapList = CopyObjectUtil.compare((Object)oldData, data);
        Document update = null;
        if (mapList.size() > 0) {
            for (Map map : mapList) {
                Object oldValue;
                String name = (String)map.get("name");
                if ("lastModified".equals(name)) {
                    oldValue = (Date)map.get("new");
                    update = new Document("$set", (Object)new BsonDocument(name, (BsonValue)new BsonDateTime(((Date)oldValue).getTime())));
                } else if ("parentId".equals(name)) {
                    oldValue = (UUID)map.get("new");
                    update = new Document("$set", (Object)new Document(name, oldValue));
                } else {
                    oldValue = (String)map.get("new");
                    update = new Document("$set", (Object)new BsonDocument(name, (BsonValue)new BsonString((String)oldValue)));
                }
                mongoCollection.updateOne((Bson)filter, (Bson)update);
            }
        }
    }
}

