/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.dao.file.DirectoryNodeService;
import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.UuIdEntity;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.service.DoFileService;
import com.digiwin.dap.middleware.dmc.obsolete.service.base.AbstractDocumentService;
import com.digiwin.dap.middleware.dmc.service.business.FileDownloadService;
import com.digiwin.dap.middleware.dmc.service.business.FileUploadService;
import com.digiwin.dap.middleware.dmc.util.CopyObjectUtil;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoFileServiceImpl
extends AbstractDocumentService<FileInfo>
implements DoFileService {
    @Autowired
    private FileUploadService uploadService;
    @Autowired
    private FileDownloadService downloadService;
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private DirectoryNodeService directoryNodeService;

    public String copyFileToOtherBucket(String bucketName, String targetBucketName, String fileInfoId, UUID targetDirId, boolean isDeepClone) {
        try {
            FileInfo fileInfo = this.fileNodeService.findOne(bucketName, fileInfoId);
            if (!this.directoryNodeService.existsById(bucketName, targetDirId)) {
                throw new BusinessException("\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u590d\u5236\u5931\u8d25\uff01");
            }
            FileInfo fileInfoNew = new FileInfo();
            CopyObjectUtil.mergeObject((Object)fileInfo, (Object)fileInfoNew);
            fileInfoNew.setDirectoryId(targetDirId.toString());
            fileInfoNew.setBucket(targetBucketName);
            fileInfoNew.setBucketName(targetBucketName);
            fileInfoNew.setLastModified(new Date());
            String fulltext = FileUtil.getFullText((FileInfo)fileInfoNew);
            fileInfo.setFullText(fulltext);
            if (isDeepClone) {
                byte[] bytes = this.downloadService.downloadToBytes(bucketName, fileInfo.getId().toString());
                if (bytes.length == 0) {
                    throw new BusinessException("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u590d\u5236\u5931\u8d25\uff01");
                }
                return this.uploadService.uploadFromBytes(targetBucketName, fileInfoNew, bytes).getId().toString();
            }
            return super.insert(targetBucketName, (UuIdEntity)fileInfoNew);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    protected Class<FileInfo> getEntityClass() {
        return FileInfo.class;
    }

    protected String getCollectionName() {
        return ".fileInfos";
    }
}

