/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.obsolete.service.impl;

import com.digiwin.dap.middleware.dmc.dao.file.FileNodeService;
import com.digiwin.dap.middleware.dmc.entity.objectid.Bucket;
import com.digiwin.dap.middleware.dmc.entity.uuid.FileInfo;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.FileTypeEnum;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.FullTextCondition;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.QueryData;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.QueryItem;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.QueryResult;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.SimpleCondition;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.StdData;
import com.digiwin.dap.middleware.dmc.obsolete.domain.query.StdDataCondition;
import com.digiwin.dap.middleware.dmc.obsolete.service.FileInfoTextService;
import com.digiwin.dap.middleware.dmc.obsolete.service.impl.FileInfoTextServiceImpl;
import com.digiwin.dap.middleware.dmc.repository.BucketRepository;
import com.digiwin.dap.middleware.dmc.support.auth.domain.JwtUser;
import com.digiwin.dap.middleware.dmc.util.FileUtil;
import com.digiwin.dap.middleware.dmc.util.IdUtil;
import com.digiwin.dap.middleware.dmc.util.TenantUtil;
import com.digiwin.dap.middleware.dmc.util.UserUtil;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.util.UserUtils;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FileInfoTextServiceImpl
implements FileInfoTextService {
    private static final String MONGODB_OR = "$or";
    private static final String MONGODB_IN = "$in";
    private static final String MONGODB_NIN = "$nin";
    private static final String MONGODB_AND = "$and";
    private static final String MONGODB_TEXT = "$text";
    private static final String MONGODB_SEARCH = "$search";
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String ID_FIELD_NAME = "_id";
    private static final String SIZE_FIELD_NAME = "size";
    private static final String FILEID_FIELD_NAME = "fileId";
    private static final String EXTENSION_FIELD_NAME = "extension";
    private static final String UPLOADDATE_FIELD_NAME = "uploadDate";
    private static final String LASTMODIFIED_FIELD_NAME = "lastModified";
    private static final String SEGMENT_TOTAL_SIZE_FIELD_NAME = "segmentTotalSize";
    private static final String MESSAGE_OK = "OK";
    private static final String DESC = "desc";
    private static final String NUMBER_ONE = "1";
    @Autowired
    private FileNodeService fileNodeService;
    @Autowired
    private BucketRepository bucketRepository;

    public QueryResult getFileInfoByFileInfoQuery(String bucket, SimpleCondition query) {
        List fileInfos = this.getFileInfo(bucket, query);
        if (query.getPageSize() == 0) {
            query.setPageSize(10);
        }
        if (query.getPageNum() == 0) {
            query.setPageSize(1);
        }
        QueryResult queryResult = new QueryResult();
        queryResult.setPageNum(query.getPageNum());
        if (fileInfos.size() > query.getPageSize()) {
            queryResult.setHasNext(true);
            queryResult.setPageSize(query.getPageSize());
        } else {
            queryResult.setHasNext(false);
            queryResult.setPageSize(fileInfos.size());
        }
        queryResult.setItems(this.getQueryItems(bucket, fileInfos));
        return queryResult;
    }

    public QueryResult getFileInfo(FullTextCondition condition) {
        int size;
        QueryResult queryResult = new QueryResult();
        List buckets = this.getAuthBuckets(condition.getBuckets());
        int n = size = (buckets = this.getValidBuckets(buckets)) == null ? 0 : buckets.size();
        if (size == 0) {
            return queryResult;
        }
        if (size == 1) {
            condition.setPageSize(10);
        } else {
            condition.setPageSize(3);
        }
        QueryResult myQueryResult = null;
        for (Bucket bucket : buckets) {
            String myDocument = TenantUtil.getBucketName();
            if (!myDocument.equals(bucket.getName())) continue;
            myQueryResult = this.getFileInfo(bucket.getName(), condition);
            buckets.remove(bucket);
            --size;
            break;
        }
        if (size > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(size);
            ExecutorCompletionService cs = new ExecutorCompletionService(executor);
            for (Bucket bucket : buckets) {
                StdDataCondition body = this.getCondition(bucket, condition);
                QueryCallable task = new QueryCallable(this, bucket.getApiUrl(), body);
                cs.submit(task);
            }
            ArrayList items = new ArrayList();
            for (int i = 0; i < size; ++i) {
                try {
                    items.add(cs.take().get());
                    continue;
                }
                catch (InterruptedException e) {
                    throw new BusinessException("API\u8bf7\u6c42\u88ab\u6253\u65ad\uff01 " + e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new BusinessException("API\u8bf7\u6c42\u5931\u8d25\uff01 " + e.getMessage());
                }
            }
            executor.shutdown();
            for (QueryItem item : items) {
                ArrayList<QueryData> dataNew = new ArrayList<QueryData>();
                if (item.getData() != null) {
                    for (QueryData datum : item.getData()) {
                        FileInfo fileInfo = (FileInfo)this.fileNodeService.findById(item.getBucketName(), datum.getId());
                        if (fileInfo == null) continue;
                        QueryData temp = this.copyFileInfo(fileInfo);
                        temp.setExtensionField(datum.getExtensionField());
                        temp.setExtensionMetadata(datum.getExtensionMetadata());
                        dataNew.add(temp);
                    }
                }
                item.setData(dataNew);
            }
            if (myQueryResult != null) {
                items.addAll(myQueryResult.getItems());
            }
            queryResult.setItems(items);
        } else {
            queryResult = myQueryResult;
        }
        return queryResult;
    }

    public QueryResult getFileInfo(String bucket, FullTextCondition queryCondition) {
        Document condotion = new Document();
        Document keyword = new Document();
        String pinyin = FileUtil.getPingYin((String)FileUtil.getSegmentation((String)queryCondition.getKeyword()));
        keyword.put(MONGODB_SEARCH, (Object)pinyin);
        List suffixes = null;
        Document suffixesDocument = null;
        Document extensionDocument = null;
        Document fullTextDocument = null;
        ArrayList<Document> conditions = new ArrayList<Document>();
        if (queryCondition.getFileType() == null || FileTypeEnum.ALL == queryCondition.getFileType()) {
            if (queryCondition.getSuffixes() == null || queryCondition.getSuffixes().size() == 0) {
                condotion.put(MONGODB_TEXT, (Object)keyword);
            } else {
                suffixes = FileUtil.getFullTypes((List)queryCondition.getSuffixes());
                suffixesDocument = new Document();
                suffixesDocument.put(MONGODB_IN, (Object)suffixes);
                extensionDocument = new Document(EXTENSION_FIELD_NAME, (Object)suffixesDocument);
                fullTextDocument = new Document(MONGODB_TEXT, (Object)keyword);
                conditions.add(fullTextDocument);
                conditions.add(extensionDocument);
                condotion.put(MONGODB_AND, conditions);
            }
        } else {
            suffixesDocument = new Document();
            if (queryCondition.getSuffixes() == null || queryCondition.getSuffixes().size() == 0) {
                suffixes = FileUtil.getFileType((FileTypeEnum)queryCondition.getFileType());
                if (suffixes == null) {
                    suffixes = FileUtil.getAllTypes();
                    suffixesDocument.put(MONGODB_NIN, (Object)suffixes);
                } else {
                    suffixesDocument.put(MONGODB_IN, (Object)suffixes);
                }
            } else {
                suffixes = FileUtil.getSuffixes((FileTypeEnum)queryCondition.getFileType(), (List)queryCondition.getSuffixes());
                suffixesDocument.put(MONGODB_IN, (Object)suffixes);
            }
            extensionDocument = new Document(EXTENSION_FIELD_NAME, (Object)suffixesDocument);
            fullTextDocument = new Document(MONGODB_TEXT, (Object)keyword);
            conditions.add(fullTextDocument);
            conditions.add(extensionDocument);
            condotion.put(MONGODB_AND, conditions);
        }
        SimpleCondition query = new SimpleCondition();
        query.setCondition(condotion);
        query.setPageNum(queryCondition.getPageNum());
        query.setPageSize(queryCondition.getPageSize());
        List fileInfos = this.getFileInfo(bucket, query);
        QueryResult queryResult = new QueryResult();
        queryResult.setPageNum(queryCondition.getPageNum());
        queryResult.setPageSize(queryCondition.getPageSize());
        if (fileInfos.size() > query.getPageSize()) {
            queryResult.setHasNext(true);
        } else {
            queryResult.setHasNext(false);
        }
        if (fileInfos.size() == 0) {
            SimpleCondition simple = new SimpleCondition();
            Pattern pattern = Pattern.compile("^.*" + queryCondition.getKeyword() + ".*$");
            Document keywordDocument = new Document();
            BasicDBList keywordLists = new BasicDBList();
            keywordLists.add((Object)new BasicDBObject("fileName", (Object)pattern));
            keywordLists.add((Object)new BasicDBObject("description", (Object)pattern));
            keywordDocument.put(MONGODB_OR, (Object)keywordLists);
            if (extensionDocument != null) {
                BasicDBList lists = new BasicDBList();
                lists.add((Object)keywordDocument);
                lists.add((Object)extensionDocument);
                condotion = new Document(MONGODB_AND, (Object)lists);
            } else {
                condotion = keywordDocument;
            }
            simple.setCondition(condotion);
            fileInfos = this.getFileInfo(bucket, simple);
        }
        List items = this.getQueryItems(bucket, fileInfos);
        queryResult.setItems(items);
        return queryResult;
    }

    private List<Bucket> getAuthBuckets(List<String> bucketNames) {
        ArrayList<Bucket> buckets = new ArrayList();
        JwtUser jwtUser = UserUtil.getJwtUser();
        List authBuckets = jwtUser.getIam() != false ? this.bucketRepository.findByApiUrlNotNull() : this.bucketRepository.findByOwnerAndApiUrlNotNull(UserUtils.getUserId());
        if (bucketNames == null || bucketNames.size() == 0) {
            buckets = authBuckets;
        } else {
            for (Bucket bucket : authBuckets) {
                if (!bucketNames.contains(bucket.getName())) continue;
                buckets.add(bucket);
            }
        }
        return buckets;
    }

    private List<Bucket> getValidBuckets(List<Bucket> buckets) {
        ArrayList<Bucket> lists = new ArrayList<Bucket>();
        for (Bucket bucket : buckets) {
            String myDocument = TenantUtil.getBucketName();
            if (myDocument.equals(bucket.getName())) {
                lists.add(bucket);
                continue;
            }
            URI uri = null;
            try {
                uri = new URI(bucket.getApiUrl());
                uri.toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            lists.add(bucket);
        }
        return lists;
    }

    private StdDataCondition getCondition(Bucket bucket, FullTextCondition condition) {
        FullTextCondition fullTextCondition = new FullTextCondition();
        fullTextCondition.setIam(condition.isIam());
        fullTextCondition.setIamAccessToken(condition.getIamAccessToken());
        fullTextCondition.setKeyword(condition.getKeyword());
        fullTextCondition.setSuffixes(condition.getSuffixes());
        fullTextCondition.setBucketName(bucket.getName());
        fullTextCondition.setPageNum(condition.getPageNum());
        fullTextCondition.setPageSize(condition.getPageSize());
        StdDataCondition stdDataCondition = new StdDataCondition();
        StdData stdData = new StdData();
        stdData.setParameter((Object)fullTextCondition);
        stdDataCondition.setStd_data(stdData);
        return stdDataCondition;
    }

    public Document createQueryCondition(String field, String value, String operator) {
        Document body = new Document();
        Object data = this.convertType(field, value);
        if (StringUtils.isEmpty((Object)operator)) {
            body.append(field, (Object)value);
        } else {
            Document operation = new Document();
            operation.append(operator, data);
            body.append(field, (Object)operation);
        }
        return body;
    }

    private Object convertType(String field, String value) {
        try {
            if (ID_FIELD_NAME.equals(field) || FILEID_FIELD_NAME.equals(field)) {
                return IdUtil.uuid((String)value);
            }
            if (SIZE_FIELD_NAME.equals(field) || SEGMENT_TOTAL_SIZE_FIELD_NAME.equals(field)) {
                return Integer.valueOf(value);
            }
            if (LASTMODIFIED_FIELD_NAME.equals(field) || UPLOADDATE_FIELD_NAME.equals(field)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
                return simpleDateFormat.parse(value);
            }
            return value;
        }
        catch (ParseException e) {
            throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    private List<QueryItem> getQueryItems(String bucketName, List<FileInfo> fileInfos) {
        ArrayList<QueryItem> items = new ArrayList<QueryItem>();
        QueryItem item = this.getQueryItem(bucketName, fileInfos);
        items.add(item);
        return items;
    }

    private QueryItem getQueryItem(String bucketName, List<FileInfo> fileInfos) {
        QueryItem queryItem = new QueryItem();
        queryItem.setBucketName(bucketName);
        queryItem.setMessage(MESSAGE_OK);
        queryItem.setData(this.copyFileInfo(fileInfos));
        return queryItem;
    }

    private List<QueryData> copyFileInfo(List<FileInfo> fileInfos) {
        ArrayList<QueryData> queryData = new ArrayList<QueryData>();
        for (FileInfo fileInfo : fileInfos) {
            queryData.add(this.copyFileInfo(fileInfo));
        }
        return queryData;
    }

    private QueryData copyFileInfo(FileInfo fileInfo) {
        QueryData queryData = new QueryData();
        BeanUtils.copyProperties((Object)fileInfo, (Object)queryData);
        return queryData;
    }

    public List<FileInfo> getFileInfo(String bucket, SimpleCondition query) {
        Document condition = query.getCondition();
        List lists = query.getFields();
        Document fields = null;
        if (lists != null) {
            fields = new Document();
            for (String filed : lists) {
                fields.append(filed, (Object)NUMBER_ONE);
            }
        }
        Map map = query.getSort();
        Document sort = null;
        if (map != null) {
            sort = new Document();
            for (Map.Entry entry : map.entrySet()) {
                String field = (String)entry.getValue();
                Integer value = DESC.equals(field) ? -1 : 1;
                sort.append((String)entry.getKey(), (Object)value);
            }
        }
        int pageNum = query.getPageNum();
        int pageSize = query.getPageSize();
        int skip = (pageNum - 1) * pageSize;
        int limit = pageSize + 1;
        return this.fileNodeService.findByCondition(bucket, (Bson)condition, (Bson)fields, (Bson)sort, skip, limit);
    }

    public List<FileInfo> getFileInfoTest(String bucket, SimpleCondition query) {
        Document condition = query.getCondition();
        List lists = query.getFields();
        Document fields = null;
        if (lists != null) {
            fields = new Document();
            for (String filed : lists) {
                fields.append(filed, (Object)NUMBER_ONE);
            }
        }
        Map map = query.getSort();
        Document sort = null;
        if (map != null) {
            sort = new Document();
            for (Map.Entry entry : map.entrySet()) {
                String field = (String)entry.getValue();
                Integer value = DESC.equals(field) ? -1 : 1;
                sort.append((String)entry.getKey(), (Object)value);
            }
        }
        return this.fileNodeService.findByCondition(bucket, (Bson)condition, (Bson)fields, (Bson)sort);
    }
}

